<?php

/**
 * 限时活动
 */

namespace Game\Model\Activity;

use Framework\Logic\TemplateHelp;
use Game\Data\Activity\LimitTimeData;


class LimitTimeModel
{
    use TemplateHelp;


    private int $playerId;
    public LimitTimeData $data;

    public function __construct()
    {
        $this->data = new LimitTimeData();
    }

    public function setPlayerId($playerId)
    {
        $this->playerId = $playerId;
        $this->data->playerID = $playerId;
    }

    public function getPlayerId(): int
    {
        return $this->playerId;
    }

    public function getLimitTimeData(): void {
        $this->data->searchDB();
    }

    public function onRegister()
    {
        $this->data->exchangeRecord = [];
        $this->data->registerDB();
    }

    public function updateLimitTimeData(): bool {
        return $this->data->updateDB();
    }
}
