<?php

/**
 * 限时活动
 */

namespace Game\Model\Activity;

use Framework\Logic\TemplateHelp;
use Game\Data\Activity\FestivalRewardData;


class FestivalRewardModel
{
    use TemplateHelp;


    private int $playerId;
    public FestivalRewardData $data;

    public function __construct()
    {
        $this->data = new FestivalRewardData();
    }

    public function setPlayerId($playerId)
    {
        $this->playerId = $playerId;
        $this->data->playerID = $playerId;
    }

    public function getPlayerId(): int
    {
        return $this->playerId;
    }

    public function getFestivalRewardData($id): void {
        $this->data->searchDB($id);
    }

    public function updateFestivalRewardData($id): bool {
        return $this->data->updateDB($id);
    }
}
