<?php

/**
 * 临时用!!!后续红点功能更新后需删除
 * 登录返回红点相关
 */

namespace Game\Method\Task;

use Framework\DB\Handler\PlayerDBHandler;
use Framework\MVC\ModelManager;
use Framework\Network\SendMessage;
use Game\Constant\DBTableDefine;
use Game\Constant\ModelTypeDefine;
use Game\Data\TaskData;
use Game\Logic\ProficiencyLogic;
use Game\Logic\Task\TaskLogic;
use Game\Model\Task\ActiveModel;
use Game\Model\Task\Manager\SeasonTaskManager;
use Game\Model\Task\WarTokenModel;
use Game\Protobuf\GCTaskList;
use Game\Protobuf\PacketId;
use Game\Protobuf\Task;

trait GetTaskOnLogin
{
    use PlayerDBHandler;
    use TaskLogic;
    use ProficiencyLogic;

    //登陆获取日常任务,战令任务,熟练度任务
    public function sendTaskListOnLoginCheckMsg(int $playerId)
    {
        $taskList = array();
        $completeTaskList = array();
        //日常任务
        $tmpTaskList = $this->getDailyTask();
        $taskList = array_merge($taskList, $tmpTaskList[0]);
        $completeTaskList = array_merge($completeTaskList, $tmpTaskList[1]);
        //日常挑战
        $tmpTaskList = $this->getDailyChallengeTask();
        $taskList = array_merge($taskList, $tmpTaskList[0]);
        $completeTaskList = array_merge($completeTaskList, $tmpTaskList[1]);
        //主线任务(成长任务)
        $tmpTaskList = $this->getMainTask();
        $taskList = array_merge($taskList, $tmpTaskList[0]);
        $completeTaskList = array_merge($completeTaskList, $tmpTaskList[1]);
        //战令任务
        /**
         * @var SeasonTaskManager $seasonTaskManager
         */
        $seasonTaskManager = ModelManager::getInstance()->getModel(ModelTypeDefine::TASK_SEASON);
        $openWeek = $seasonTaskManager->getOpenSeasonWeek();
        for ($week = 0; $week <= $openWeek; $week++) {
            $tmpTaskList = $this->getSeasonTask($week);
            $taskList = array_merge($taskList, $tmpTaskList[0]);
            $completeTaskList = array_merge($completeTaskList, $tmpTaskList[1]);
        }
        //查询全部车
        $carList = array();
        $this->getTitleList(DBTableDefine::TABLE_CAR, $playerId, $carList);
        foreach ($carList as $carUid => $carId) {
            $tmpTaskList = $this->getBranchTask($carId);
            $taskList = array_merge($taskList, $tmpTaskList[0]);
            $completeTaskList = array_merge($completeTaskList, $tmpTaskList[1]);
        }
        //发送任务相关消息
        $sendMessage = new GCTaskList();
        $taskMessage = array();
        /**
         * @var TaskData $taskData
         */
        foreach ($taskList as $taskData) {
            $task = new Task();
            $task->setTaskId($taskData->taskId);
            $task->setStatus($taskData->status);
            $task->setSchedule($taskData->schedule);
            $taskMessage[] = $task;
        }
        $sendMessage->setTaskList($taskMessage);
        $sendMessage->setCompleteTaskList($completeTaskList);
        SendMessage::getInstance()->sendClient(PacketId::GC_TaskList, $sendMessage);
        //活跃度
        /**
         * @var ActiveModel $activeModel
         */
        $activeModel = ModelManager::getInstance()->getModel(ModelTypeDefine::TASK_ACTIVE);
        $activeModel->sendActiveMessage();
        //熟练度信息
        $this->sendProficiencyDataMessage($this->getTotalProficiencyData());
        //战令信息
        /**
         * @var WarTokenModel $warTokenModel
         */
        $warTokenModel = ModelManager::getInstance()->getModel(ModelTypeDefine::WAR_TOKEN);
        $warTokenModel->sendMessage();
    }
}