<?php

/**
 * 创建账号 分步创建信息
 */

namespace Game\Method\Player;

use Framework\DB\Handler\PlayerDBPipe;
use Framework\Log\LogMark;
use Framework\MVC\ModelManager;
use Game\Constant\ModelTypeDefine;
use Game\Logic\Task\TaskEventLogic;
use Game\Model\Task\Manager\DailyChallengeTaskManager;
use Game\Model\Task\Manager\DailyTaskManager;
use Game\Model\Task\Manager\LimitActivityTaskManager;
use Game\Model\Task\Manager\MainTaskManager;
use Game\Model\Task\Manager\SeasonTaskManager;
use Game\Model\Task\Manager\WeekTaskManager;

trait InitPlayerDataLogic
{
    use TaskEventLogic;

    /**
     * 注册后 初始信息1
     * @param int $playerId
     */
    private function initPlayerData1(int $playerId)
    {
        PlayerDBPipe::getInstance()->start($playerId);
        foreach (ModelTypeDefine::MODEL_MAP1 as $modelType => $value) {
            $model = ModelManager::getInstance()->getModel($modelType);
            if (!is_null($model) && method_exists($model, "onRegister")) {
                $model->onRegister();
            }
        }
        PlayerDBPipe::getInstance()->finish();
    }

    /**
     * 注册后 初始信息2
     * @param int $playerId
     */
    private function initPlayerData2(int $playerId)
    {
        PlayerDBPipe::getInstance()->start($playerId);
        foreach (ModelTypeDefine::MODEL_MAP2 as $modelType => $value) {
            $model = ModelManager::getInstance()->getModel($modelType);
            if (!is_null($model) && method_exists($model, "onRegister")) {
                $model->onRegister();
            }
        }
        PlayerDBPipe::getInstance()->finish();
    }

    /**
     * 注册后 初始信息3
     * @param int $playerId
     */
    private function initPlayerData3(int $playerId)
    {
        //查询赛季开启到第几周
        /**
         * @var SeasonTaskManager $seasonTaskManager
         */
        $seasonTaskManager = ModelManager::getInstance()->getModel(ModelTypeDefine::TASK_SEASON);
        $openWeek = $seasonTaskManager->getOpenSeasonWeek();

        PlayerDBPipe::getInstance()->start($playerId);
        //创建任务
        $this->initTaskOnRegisterOver($openWeek);
        foreach (ModelTypeDefine::MODEL_MAP3 as $modelType => $value) {
            $model = ModelManager::getInstance()->getModel($modelType);
            if (!is_null($model) && method_exists($model, "onRegister")) {
                $model->onRegister();
            }
        }
        //批量注册事件
        $this->pipeRegisterEventData();
        PlayerDBPipe::getInstance()->finish();
    }

    //注册完成后,初始任务
    public function initTaskOnRegisterOver(int $openWeek)
    {
        /**
         * @var DailyTaskManager $dailyTaskManager
         */
        $dailyTaskManager = ModelManager::getInstance()->getModel(ModelTypeDefine::TASK_DAILY);
        $dailyTaskManager->initDailyTaskOnRegisterOver();
        /**
         * @var MainTaskManager $mainTaskManager
         */
        $mainTaskManager = ModelManager::getInstance()->getModel(ModelTypeDefine::TASK_MAIN);
        $mainTaskManager->initMainTaskOnRegisterOver();
        /**
         * @var SeasonTaskManager $seasonTaskManager
         */
        $seasonTaskManager = ModelManager::getInstance()->getModel(ModelTypeDefine::TASK_SEASON);
        $seasonTaskManager->initSeasonTaskOnRegisterOver($openWeek);
        /**
         * @var DailyChallengeTaskManager $dayChallengeTaskManager
         */
        $dayChallengeTaskManager = ModelManager::getInstance()->getModel(ModelTypeDefine::TASK_DAILY_CHALLENGE);
        $dayChallengeTaskManager->initDailyChallengeTaskOnRegisterOver();
        // 福利周任务初始化
        /**
         * @var WeekTaskManager $weekTaskManager
         */
        $weekTaskManager = ModelManager::getInstance()->getModel(ModelTypeDefine::TASK_WELFARE_WEEK);
        $weekTaskManager->initWelfareWeekTaskOnRegisterOver();

        // 限时任务初始化
        /**
         * @var LimitActivityTaskManager $limitActivityTaskManager
         */
        $limitActivityTaskManager = ModelManager::getInstance()->getModel(ModelTypeDefine::TASK_LIMIT_ACTIVITY);
        $limitActivityTaskManager->initExchangeTaskOnRegisterOver();
        $limitActivityTaskManager->initFestivalTaskOnRegisterOver();
        $limitActivityTaskManager->initTargetTaskOnRegisterOver();
    }
}
