<?php


namespace Game\Method\Money;


use Framework\Logic\TemplateHelp;
use Framework\MVC\ModelManager;
use Game\Constant\ModelTypeDefine;
use Game\Model\MailModel;
use Game\Model\MoneyModel;

trait ItemMoney
{
    public function getMoneyNum($moneyType): int
    {
        /**
         * @var MoneyModel $money
         */
        $money = ModelManager::getInstance()->getModel(ModelTypeDefine::MONEY);
        if ($money->checkType($moneyType) == false) {
            return 0;
        }
        return $money->search($moneyType);
    }
}