<?php


namespace Game\Method\Mail;


use Framework\Logic\TemplateHelp;
use Framework\MVC\ModelManager;
use Game\Constant\ModelTypeDefine;
use Game\Model\MailModel;

trait ItemMail
{
    use TemplateHelp;
    /**
     * @param int $mailTplId
     * @param int $receiveTime
     * @param array $enclosure
     * @param int $expireTime
     * @param int $toPlayerId 发送给哪个玩家
     * @param int $fromPlayerId 来源,系统为0
     * @param string $content 替换邮件内容 json 部分邮件使用 部分会读表
     * @param string $replaceString
     * @return bool
     */
    public function itemCreatePlayerMail(int $mailTplId, int $receiveTime, array $enclosure = array(),
                                     int $expireTime = 0, int $toPlayerId = 0, int $fromPlayerId = 0,
                                     string $content = "", string $replaceString = "[]"): bool
    {
        /**
         * @var MailModel $mailModel
         */
        $mailModel = ModelManager::getInstance()->getModel(ModelTypeDefine::MAIL);
        if ($mailModel->createMail($mailTplId, $receiveTime, $enclosure, $expireTime, $toPlayerId, $fromPlayerId, $content, $replaceString)) {
            $mailModel->addPacketMessage($toPlayerId);
            return true;
        }
        return false;
    }
}