<?php


namespace Game\Method\Item;


use Framework\Logic\TemplateHelp;
use Framework\MVC\ModelManager;
use Game\Constant\ConstTemplate\TemplateItem;
use Game\Constant\ModelTypeDefine;
use Game\Constant\TemplateDefine;
use Game\Model\Car\CarModel;
use Game\Model\ItemModel;

trait AddItem
{
    use TemplateHelp;
    /**
     * 添加非现时道具，可以添加任何道具，最通用的接口之一
     * 加车，加衣服，进行折算，累加已有道具
     * @param int $itemId
     * @param int $num
     * @return bool
     */
    public function AddItem(int $itemId, int $num): bool
    {
        if($itemId == 0){
            return false;
        }
        /***
         * @var $itemCfg
         */
        $itemCfg = $this->getTitle(TemplateDefine::TYPE_ITEM, $itemId);
        if($itemCfg == null){
            return false;
        }
        switch ($itemCfg[TemplateItem::ItemType])
        {
            case TemplateItem::ITEM_TYPE_CAR:
            {
                $this->AddCar($itemId, $num);
            }break;
            case TemplateItem::ITEM_TYPE_CLOTH:
            {

            }break;
            default:
            {

            }
        }
    }

    /**
     * 添加永久车辆到玩家身上
     *
     * @param int $carId
     * @param int $num
     */
    public function AddCar(int $carId, int $num)
    {
        /**
         * @var CarModel $carModel
         */
        $carModel = ModelManager::getInstance()->getModel(ModelTypeDefine::CAR);
        $carCfg = $this->getTitle(TemplateDefine::TYPE_CAR, $carId);




    }

    public function AddCloth(int $cloth, int $num)
    {

    }

}