<?php

namespace Game\Method\Activity;

use Framework\DB\Handler\PlayerDBHandler;
use Framework\Define\ErrorDefine;
use Framework\Lib\Utils;
use Framework\Log\LogMark;
use Framework\Logic\TemplateHelp;
use Framework\MVC\ModelManager;
use Framework\Network\SendMessage;
use Game\Constant\ConstTemplate\TemplateTask;
use Game\Constant\ConstTemplate\TemplateTaskExchange;
use Game\Constant\ConstTemplate\TemplateTaskFestival;
use Game\Constant\ConstTemplate\TemplateTaskTarget;
use Game\Constant\GameErrorCode;
use Game\Constant\ModelTypeDefine;
use Game\Constant\TemplateDefine;
use Game\Data\TaskData;
use Game\Model\Activity\TaskExchangeLoginModel;
use Game\Model\Shop\ShopTaskExchangeModel;
use Game\Protobuf\GCActivityLogin;
use Game\Protobuf\GCExchangeShop;
use Game\Protobuf\GCExchangeTask;
use Game\Protobuf\PacketId;
use Game\Protobuf\ShopItem;
use Game\Protobuf\Task;

trait PushActivityLimitTimeTask
{
    use PlayerDBHandler;
    use TemplateHelp;

    public function PushAcitvityRedInfo($playerID) {
        $nowTime = Utils::getServerTimestamp();
//        $festival = [];
        for($moduleID = 1; $moduleID <=3; $moduleID ++) {
            switch ($moduleID) {
                case 1:
                    $activitys = $this->getTable(TemplateDefine::TYPE_TASK_EXCHANGE);
                    foreach ($activitys as $task) {
                        // 检测用户开启的活动
                        if($nowTime >= $task[TemplateTaskExchange::StartTime] && $nowTime
                            <= $task[TemplateTaskExchange::EndTime]) {
                            $this->searchInfoPushMsg($moduleID, $task[TemplateTaskExchange::Id], $task, $playerID);
                        }
                    }
                    break;
                case 2:
                    $activitys = $this->getTable(TemplateDefine::TYPE_TASK_TARGET);
                    foreach ($activitys as $task) {
                        // 检测用户开启的活动
                        if($nowTime >= $task[TemplateTaskTarget::StartTime] && $nowTime
                            <= $task[TemplateTaskTarget::EndTime]) {
                            $this->searchInfoPushMsg($moduleID, $task[TemplateTaskTarget::Id], $task, $playerID);
                        }
                    }
                    break;
                case 3:
                    $activitys = $this->getTable(TemplateDefine::TYPE_TASK_FESTIVAL);
                    foreach ($activitys as $task) {
//                        if(in_array($task[TemplateTaskFestival::UseType], $festival)) {
//                            continue;
//                        }
                        // 检测用户开启的活动
                        if($nowTime >= $task[TemplateTaskFestival::StartTime] && $nowTime
                            <= $task[TemplateTaskFestival::EndTime]) {
                            $this->searchInfoPushMsg($moduleID, $task[TemplateTaskFestival::Id], $task, $playerID);
//                            $festival[] = $task[TemplateTaskFestival::UseType];
                            break;
                        }
                    }
                    break;
            }
        }

    }

    public function searchInfoPushMsg($moduleID, $activeID, $taskExchangeCfg, $playerID): int
    {

        if(is_null($taskExchangeCfg)) {
            LogMark::getInstance()->markError(GameErrorCode::DATA_SEARCH_ERROR, 'get activity task 
            info cfg error!');
        }
        switch($taskExchangeCfg[TemplateTaskExchange::TaskType]) {
            case TemplateTaskExchange::TASK_TYPE_SHOP:
                $this->sendShopMsg($activeID, $moduleID);
                break;
            case TemplateTaskExchange::TASK_TYPE_LOGIN_NUM:
                $this->sendTaskLoginMsg($activeID, $moduleID);
                break;
            default:
                $this->sendTaskMsg($activeID, $taskExchangeCfg[TemplateTaskExchange::TaskId], $moduleID, $playerID);
                break;
        }
        return ErrorDefine::SUCCESS;
    }

    public function sendShopMsg($activeID, $module) {
        /**
         * @var ShopTaskExchangeModel $shopTaskExchangeModel
         */
        $shopTaskExchangeModel = ModelManager::getInstance()->getModel(ModelTypeDefine::SHOP_TASK_EXCHANGE);
        $items = $shopTaskExchangeModel->getShopItem($activeID);
        $sendItem = [];
        foreach ($items as $id => $num) {
            $item = new ShopItem();
            $item->setId($id);
            $item->setBuyNum($num);
            $sendItem[] = $item;
        }
        $sendShopMessage = new GCExchangeShop();
        $sendShopMessage->setModuleID($module);
        $sendShopMessage->setItem($sendItem);
        $sendShopMessage->setActiveID($activeID);
        SendMessage::getInstance()->sendClient(PacketId::GC_ExchangeShop, $sendShopMessage);
    }

    public function sendTaskLoginMsg($activeID, $module) {
        /**
         * @var TaskExchangeLoginModel $taskExchangeModel
         */
        $taskExchangeModel = ModelManager::getInstance()->getModel(ModelTypeDefine::TASK_EXCHANGE_LOGIN);
        $taskExchangeModel->data->searchDB($activeID);
        $sendLoginMessage = new GCActivityLogin();
        $sendLoginMessage->setLogin($taskExchangeModel->data->loginRecord);
        $sendLoginMessage->setRewardRecord($taskExchangeModel->data->rewardRecord);
        $sendLoginMessage->setModuleID($module);
        $sendLoginMessage->setActiveID($activeID);
        SendMessage::getInstance()->sendClient(PacketId::GC_ActivityLogin, $sendLoginMessage);
    }

    public function sendTaskMsg($activeID, $tasks, $module, $playerID) {
        /**
         * @var TaskExchangeLoginModel $taskExchangeModel
         */
        $taskExchangeModel = ModelManager::getInstance()->getModel(ModelTypeDefine::TASK_EXCHANGE_LOGIN);
        $taskExchangeModel->setPlayerId($playerID);
        $taskList = [];
        [$taskArr, $completeTasks] = $taskExchangeModel->getExchangeTask($tasks);
        /**User_Login_Send
         * @var TaskData $task
         */
        foreach ($taskArr as $task) {
            $taskMsg = new Task();
            $taskMsg->setStatus($task->status);
            $taskMsg->setSchedule($task->schedule);
            $taskMsg->setTaskId($task->taskId);
            $taskList[] = $taskMsg;
        }
        $sendTaskMessage = new GCExchangeTask();
        $sendTaskMessage->setTaskList($taskList);
        $sendTaskMessage->setCompleteTaskList($completeTasks);
        $sendTaskMessage->setActiveID($activeID);
        $sendTaskMessage->setModuleID($module);
        SendMessage::getInstance()->sendClient(PacketId::GC_ExchangeTask, $sendTaskMessage);
    }
}