<?php

/**
 * 战令
 */

namespace Game\Logic;

use Framework\Log\LogMark;
use Framework\MVC\ModelManager;
use Framework\Logic\TemplateHelp;
use Game\Constant\ClientErrorCode;
use Game\Constant\ConstTemplate\TemplateConst;
use Game\Constant\GameConstantDefine;
use Game\Constant\GameErrorCode;
use Game\Constant\ModelTypeDefine;
use Game\Constant\TemplateDefine;
use Game\Data\WarTokenData;
use Game\Model\AccountModel;
use Game\Model\MoneyModel;
use Game\Model\Task\WarTokenModel;

trait WarTokenLogic
{
    use TemplateHelp;
    use ItemLogic;
    use SeasonLogic;

    //获取战令信息
    public function getWarTokenData(): object
    {
        /**
         * @var WarTokenModel $warTokenModel
         */
        $warTokenModel = ModelManager::getInstance()->getModel(ModelTypeDefine::WAR_TOKEN);
        return $warTokenModel->getWarTokenData();
    }

    //购买等级校验--暂时无校验
    public function checkBuyWarTokenLevel(int $level): int
    {
        //检查赛季状态
        if ($this->getSeasonStatus() == GameConstantDefine::SEASON_STATUS_CLOSE) {
            return ClientErrorCode::SEASON_CLOSE;
        }
        $sub = $this->getTerm(TemplateDefine::TYPE_CONST,
            TemplateConst::Const_ZL_Buy_Level_Sub,
            TemplateConst::ConstNum);
        /**
         * @var AccountModel $account
         */
        $account = ModelManager::getInstance()->getModel(ModelTypeDefine::ACCOUNT);
        $diamond = $account->getMoney(MoneyModel::TYPE_DIAMOND);
        if($sub * $level > $diamond) {
            return $this->getMoneyNotEnoughCode(MoneyModel::TYPE_DIAMOND);
        }
        return ClientErrorCode::CLIENT_SUCCESS;
    }

    //购买等级
    public function buyWarTokenLevel(int $level)
    {
        /**
         * @var WarTokenModel $warTokenModel
         */
        $warTokenModel = ModelManager::getInstance()->getModel(ModelTypeDefine::WAR_TOKEN);
        $addExp = $this->getTerm(TemplateDefine::TYPE_CONST,
                                             TemplateConst::Const_Task_ZL_Level_Exp,
                                             TemplateConst::ConstNum);
        if (is_null($addExp)) {
            LogMark::getInstance()->markWarn(
                GameErrorCode::TEMPLATE_ID_NOT_FOUND,
                "[WarTokenLogic] const table not found",
                array(
                    "TemplateTable" => TemplateDefine::TYPE_CONST,
                    "id" => TemplateConst::Const_Task_ZL_Level_Exp,
                )
            );
            $addExp = 0;
        }
        $sub = $this->getTerm(TemplateDefine::TYPE_CONST,
            TemplateConst::Const_ZL_Buy_Level_Sub,
            TemplateConst::ConstNum);
        $this->setLogConsumeItemSource(GameConstantDefine::ITEM_CONSUME_SOURCE_BUY_ZL_LV);
        $this->subItemByTID(MoneyModel::TYPE_DIAMOND, $sub * $level);
        $warTokenModel->addWarTokenExp($addExp * $level);
        // 将道具一键领取了
        $this->oneKeyGetWarTokenReward();
    }

    //开通高级校验
    public function checkOpenExpertFlag(int $id = 0): int
    {
        if ($id != 0) {
            //检查钻石
            if ($id == WarTokenData::EXPERT_FLAG_PRIMARY) {
                $needNum = $this->getTerm(
                    TemplateDefine::TYPE_CONST,
                    TemplateConst::Const_ZL_Open_Expert_Normal,
                    TemplateConst::ConstNum);
            } else {
                $needNum = $this->getTerm(
                    TemplateDefine::TYPE_CONST,
                    TemplateConst::Const_ZL_Open_Expert_Expert,
                    TemplateConst::ConstNum);
            }
            if ($this->getMoney(MoneyModel::TYPE_DIAMOND) < $needNum) {
                return $this->getMoneyNotEnoughCode(MoneyModel::TYPE_DIAMOND);
            }
        }
        /**
         * @var WarTokenData $warTokenData
         */
        $warTokenData = $this->getWarTokenData();
        if ($warTokenData->expertFlag !== $warTokenData::EXPERT_FLAG_DEFAULT) {
            return ClientErrorCode::WAR_TOKEN_EXPERT_IS_OPEN;
        }
        //检查赛季状态
        if ($this->getSeasonStatus() == GameConstantDefine::SEASON_STATUS_CLOSE) {
            return ClientErrorCode::SEASON_CLOSE;
        }
        return ClientErrorCode::CLIENT_SUCCESS;
    }

    //开通高级 直接开通
    public function openExpertFlag(int $level): void
    {
        /**
         * @var WarTokenModel $warTokenModel
         */
        $warTokenModel = ModelManager::getInstance()->getModel(ModelTypeDefine::WAR_TOKEN);
        $warTokenData =  $warTokenModel->getWarTokenData();
        $warTokenData->setExpertFlag($level);
        $warTokenData->updateDB();
        $warTokenModel->sendMessage();
    }

    // 开通高级 增加等级
    public function addZlLevel(int $level): void
    {
        /**
         * @var WarTokenData $warTokenData
         */
        if($level == WarTokenData::EXPERT_FLAG_EXPERT) {
            /**
             * @var WarTokenModel $warTokenModel
             */
            $warTokenModel = ModelManager::getInstance()->getModel(ModelTypeDefine::WAR_TOKEN);
            $level = (int)$this->getTerm(
                TemplateDefine::TYPE_CONST,
                TemplateConst::Const_ZL_High_Add_Level,
                TemplateConst::ConstNum);
            $exp = (int)$this->getTerm(
                TemplateDefine::TYPE_CONST,
                TemplateConst::Const_Task_ZL_Level_Exp,
                TemplateConst::ConstNum);
            $warTokenModel->addWarTokenExp($level * $exp);
        }

    }

    //检查战令奖励是否可领取
    public function checkGetWarTokenReward(int $id, int $option): int
    {
        /**
         * @var WarTokenModel $warTokenModel
         */
        $warTokenModel = ModelManager::getInstance()->getModel(ModelTypeDefine::WAR_TOKEN);
        //检查奖励id是否存在
        if (false == $warTokenModel->checkRewardIsExist($id, $option)) {
            return ClientErrorCode::WAR_TOKEN_REWARD_NOT_FOUND;
        }
        //最大可领取id
        $canGatLv = $warTokenModel->getWarTokenCanLv();
        if ($canGatLv == 0) {
            //不可领取
            return ClientErrorCode::WAR_TOKEN_NO_REWARD_CAN_GET;
        }
        if ($id > $canGatLv) {
            //不可领取
            return ClientErrorCode::WAR_TOKEN_NO_REWARD_CAN_GET;
        }
        /**
         * @var WarTokenData $warTokenData
         */
        $warTokenData = $warTokenModel->getWarTokenData();
        if ($option == WarTokenData::EXPERT_FLAG_DEFAULT) {
            //检查初级奖励
            $primaryIdList = $warTokenModel->getPrimaryIdList();
            if (in_array($id, $primaryIdList)) {
                return ClientErrorCode::WAR_TOKEN_REWARD_ALREADY_GET;
            }
        } else {
            if (false == $warTokenData->expertFlag) {
                return ClientErrorCode::WAR_TOKEN_NOT_OPEN_EXPERT;
            }
            //检查高级奖励
            $expertIdList = $warTokenModel->getExpertIdList();
            if (in_array($id, $expertIdList)) {
                return ClientErrorCode::WAR_TOKEN_REWARD_ALREADY_GET;
            }
        }
        return ClientErrorCode::CLIENT_SUCCESS;
    }

    //领取单个奖励--校验完成后
    public function getWarTokenReward(int $id, int $option = 0)
    {
        /**
         * @var WarTokenModel $warTokenModel
         */
        $warTokenModel = ModelManager::getInstance()->getModel(ModelTypeDefine::WAR_TOKEN);
        $reward = array();
        //领取奖励
        switch($option) {
            case WarTokenData::OVER_MAX_FLAG_DEFAULT:
                $warTokenModel->getPrimaryReward($id, $reward);
                break;
            case WarTokenData::EXPERT_FLAG_PRIMARY:
            case WarTokenData::EXPERT_FLAG_EXPERT:
                $warTokenModel->getExpertReward($id, $reward, $option);
                break;
        }
        // 加道具
        $this->setLogAddItemSource(GameConstantDefine::ITEM_ADD_SOURCE_ZL_REWARD);
        $this->gainItemArr($reward);
        // 保存
        $warTokenModel->saveWarTokenData();
        // 发消息
        $warTokenModel->sendMessage();
    }

    //一键领取奖励
    public function oneKeyGetWarTokenReward()
    {
        /**
         * @var WarTokenModel $warTokenModel
         */
        $warTokenModel = ModelManager::getInstance()->getModel(ModelTypeDefine::WAR_TOKEN);
        //最大可领取id
        $canGatLv = $warTokenModel->getWarTokenCanLv();
        if ($canGatLv == 0) {
            return;
        }
        $warTokenData = $warTokenModel->getWarTokenData();
        $reward = array();
        //领取初级奖励
        $primaryIdList = $warTokenModel->getPrimaryIdList();
        if (count($primaryIdList) < $canGatLv) {
            for ($i = 1; $i <= $canGatLv; $i++) {
                if (in_array($i, $primaryIdList)) {
                    continue;
                }
                $warTokenModel->getPrimaryReward($i, $reward);
            }
        }
        //领取高级奖励
        if ($warTokenData->expertFlag) {
            $expertIdList = $warTokenModel->getExpertIdList();
            if (count($expertIdList) < $canGatLv) {
                for ($i = 1; $i <= $canGatLv; $i++) {
                    if (in_array($i, $expertIdList)) {
                        continue;
                    }
                    $warTokenModel->getExpertReward($i, $reward, $warTokenData->expertFlag);
                }
            }
        }
        //加道具
        if (!empty($reward)) {
            $warTokenModel->saveWarTokenData();
            $this->setLogAddItemSource(GameConstantDefine::ITEM_ADD_SOURCE_ZL_REWARD);
            $this->gainItemArr($reward);
        }
        $warTokenModel->sendMessage();
    }

    public function sendWarTokenMessage()
    {
        /**
         * @var WarTokenModel $warTokenModel
         */
        $warTokenModel = ModelManager::getInstance()->getModel(ModelTypeDefine::WAR_TOKEN);
        $warTokenModel->sendMessage();
    }
}
