<?php

/**
 * 战令每日任务
 * 参与一场排位赛/练习赛 根据胜负加战令经验
 */

namespace Game\Logic\Task;

use Framework\Logic\TemplateHelp;
use Framework\MVC\ModelManager;
use Game\Constant\ConstTemplate\TemplateConst;
use Game\Constant\GameConstantDefine;
use Game\Constant\ModelTypeDefine;
use Game\Constant\TemplateDefine;
use Game\Model\Task\WarTokenModel;

trait WarTokenDailyTaskLogic
{
    use TemplateHelp;

    //加战令周经验
    public function addWarTokenDailyTaskExp(array $param)
    {
        $addExp = 0;
        switch ($param[GameConstantDefine::EVENT_KEY_MATCH_TYPE])
        {
            case GameConstantDefine::MATCH_MODE_SINGLE_PRACTISE:
            case GameConstantDefine::MATCH_MODE_TEAM_PRACTISE:
            case GameConstantDefine::MATCH_MODE_SINGLE_PAI_WEI:
            case GameConstantDefine::MATCH_MODE_TEAM_PAI_WEI:
                if ($param[GameConstantDefine::EVENT_KEY_MATCH_WIN]) {
                    $addExp = (int)$this->getTerm(
                        TemplateDefine::TYPE_CONST,
                        TemplateConst::Const_War_Token_Daily_Win_Exp,
                        TemplateConst::ConstNum);
                } else {
                    $addExp = (int)$this->getTerm(
                        TemplateDefine::TYPE_CONST,
                        TemplateConst::Const_War_Token_Daily_Fail_Exp,
                        TemplateConst::ConstNum);
                }
                break;
            default:
                return;
        }
        if ($addExp > 0) {
            /**
             * @var WarTokenModel $warTokenModel
             */
            $warTokenModel = ModelManager::getInstance()->getModel(ModelTypeDefine::WAR_TOKEN);
            $warTokenModel->addWarTokenWeekExp($addExp);
        }
    }
}
