<?php

/**
 * 亲密度任务
 */

namespace Game\Logic\Task;

use Framework\Logic\TemplateHelp;
use Framework\MVC\ModelManager;
use Game\Constant\ClientErrorCode;
use Game\Constant\ConstTemplate\TemplateConst;
use Game\Constant\ConstTemplate\TemplateIntimacyReward;
use Game\Constant\GameConstantDefine;
use Game\Constant\ModelTypeDefine;
use Game\Constant\TemplateDefine;
use Game\Data\FriendIntimacyRewardData;
use Game\Logic\ItemLogic;
use Game\Model\Friend\FriendModel;
use Game\Model\Task\Manager\FriendIntimacyTaskManager;

trait FriendIntimacyRewardLogic
{
    use TemplateHelp;
    use ItemLogic;

    //检查开启活动
    public function checkOpenFriendIntimacyReward(int $playerId)
    {
        /**
         * @var FriendIntimacyTaskManager $friendIntimacyTaskManager
         */
        $friendIntimacyTaskManager = ModelManager::getInstance()->getModel(ModelTypeDefine::TASK_FRIEND_INTIMACY_REWARD);
        $friendIntimacyTaskManager->setPlayerId($playerId);
        //开启活动
        $data = $friendIntimacyTaskManager->getFriendIntimacySchedule();
        if ($data->friendIntimacyRewardOpen == FriendIntimacyRewardData::CLOSE) {
            //新开启
            $friendIntimacyTaskManager->openFriendIntimacySchedule();
            $friendIntimacyTaskManager->initFriendIntimacyTask($playerId);
        } else {
            //已开启 人数加1
            $friendIntimacyTaskManager->updateFriendIntimacyNum();
        }
    }

    //检查是否关闭活动
    public function checkCloseFriendIntimacyReward(int $playerId)
    {
        /**
         * @var FriendIntimacyTaskManager $friendIntimacyTaskManager
         */
        $friendIntimacyTaskManager = ModelManager::getInstance()->getModel(ModelTypeDefine::TASK_FRIEND_INTIMACY_REWARD);
        $friendIntimacyTaskManager->setPlayerId($playerId);
        $data = $friendIntimacyTaskManager->getFriendIntimacySchedule();
        if ($data->friendIntimacyRewardOpen == FriendIntimacyRewardData::OPEN) {
            //只有一个亲密关系 关闭
            $friendIntimacyTaskManager->closeFriendIntimacySchedule();
            $friendIntimacyTaskManager->closeFriendIntimacyTask();
        } elseif ($data->friendIntimacyRewardOpen > FriendIntimacyRewardData::OPEN) {
            //有多个亲密关系 不关闭 人数减1
            $friendIntimacyTaskManager->updateFriendIntimacyNum(false);
        }
    }

    //检查活动是否开启
    public function checkFriendIntimacyRewardIsOpen(): bool
    {
        /**
         * @var FriendIntimacyTaskManager $friendIntimacyTaskManager
         */
        $friendIntimacyTaskManager = ModelManager::getInstance()->getModel(ModelTypeDefine::TASK_FRIEND_INTIMACY_REWARD);
        $data = $friendIntimacyTaskManager->getFriendIntimacySchedule();
        return $data->friendIntimacyRewardOpen >= FriendIntimacyRewardData::OPEN;
    }

    //获取活动进度信息--确认开启后调用
    public function getFriendIntimacyRewardData(): FriendIntimacyRewardData
    {
        /**
         * @var FriendIntimacyTaskManager $friendIntimacyTaskManager
         */
        $friendIntimacyTaskManager = ModelManager::getInstance()->getModel(ModelTypeDefine::TASK_FRIEND_INTIMACY_REWARD);
        return $friendIntimacyTaskManager->getFriendIntimacySchedule();
    }

    //领取奖励
    public function getFriendIntimacyReward(int $rewardId, array &$schedule): int
    {
        $config = $this->getTitle(TemplateDefine::TYPE_INTIMACY_REWARD, $rewardId);
        if (is_null($config)) {
            return ClientErrorCode::FRIEND_INTIMACY_REWARD_NOT_FOUND;
        }
        /**
         * @var FriendIntimacyTaskManager $friendIntimacyTaskManager
         */
        $friendIntimacyTaskManager = ModelManager::getInstance()->getModel(ModelTypeDefine::TASK_FRIEND_INTIMACY_REWARD);
        $data = $friendIntimacyTaskManager->getFriendIntimacySchedule();
        if ($data->friendIntimacyRewardOpen == FriendIntimacyRewardData::CLOSE) {
            return ClientErrorCode::FRIEND_INTIMACY_REWARD_NOT_OPEN;
        }
        //检查积分
        if ($data->friendIntimacyRewardScore < $config[TemplateIntimacyReward::Condition]) {
            return ClientErrorCode::FRIEND_INTIMACY_REWARD_SCORE_NOT_ENOUGH;
        }
        $schedule = json_decode($data->friendIntimacyRewardSchedule, true);
        if (in_array($rewardId, $schedule)) {
            return ClientErrorCode::FRIEND_INTIMACY_REWARD_ALREADY_GET;
        }
        //领奖
        $this->setLogAddItemSource(GameConstantDefine::ITEM_ADD_SOURCE_FRIEND_INTIMACY_REWARD);
        $this->gainItemArr($config[TemplateIntimacyReward::Reward]);
        $schedule[] = $rewardId;
        $data->friendIntimacyRewardSchedule = json_encode($schedule);
        $data->updateDB();
        return ClientErrorCode::CLIENT_SUCCESS;
    }

    //增加积分 并通知
    public function addFriendIntimacyRewardScore(int $addScore)
    {
        /**
         * @var FriendIntimacyTaskManager $friendIntimacyTaskManager
         */
        $friendIntimacyTaskManager = ModelManager::getInstance()->getModel(ModelTypeDefine::TASK_FRIEND_INTIMACY_REWARD);
        $friendIntimacyTaskManager->addFriendIntimacyScore($addScore);
    }

}
