<?php

namespace Game\Logic\Task;

use Framework\MVC\ModelManager;
use Game\Constant\ModelTypeDefine;
use Game\Model\Task\Manager\BranchTaskManager;

trait BranchTaskLogic
{
    //创建支线任务
    public function createBranchTask(int $carId)
    {
        /**
         * @var BranchTaskManager $branchTaskManager
         */
        $branchTaskManager = ModelManager::getInstance()->getModel(ModelTypeDefine::TASK_BRANCH);
        if ($branchTaskManager->getIsRegister()) {
            //批量创建支线任务
            $branchTaskManager->pipeCreateBranchTask($carId);
        } else {
            $branchTaskManager->initBranchTask($carId);
        }
    }
}
