<?php

/**
 * 战令商城
 */

namespace Game\Logic\Shop;

use Framework\Logic\TemplateHelp;
use Framework\MVC\ModelManager;
use Game\Constant\ClientErrorCode;
use Game\Constant\ConstTemplate\TemplateBPStore;
use Game\Constant\EventTypeDefine;
use Game\Constant\GameConstantDefine;
use Game\Constant\ModelTypeDefine;
use Game\Constant\TemplateDefine;
use Game\Logic\EventLogic;
use Game\Logic\ItemLogic;
use Game\Logic\MoneyLogic;
use Game\Logic\SeasonLogic;
use Game\Model\Shop\ShopZLModel;

trait ShopZLLogic
{
    use TemplateHelp;
    use MoneyLogic;
    use ItemLogic;
    use EventLogic;
    use SeasonLogic;

    //购买赛季商城道具
    public function buyShopZLItem(int $id, int $num): int
    {
        if ($num <= 0) {
            return ClientErrorCode::SHOP_BUY_NUM_ERROR;
        }
        $config = $this->getTitle(TemplateDefine::TYPE_SHOP_ZL, $id);
        if (is_null($config)) {
            return ClientErrorCode::SHOP_ZL_ITEM_NOT_FOUND;
        }
        //检查赛季
        $nowSeason = $this->getSeasonId();
        if (!in_array($nowSeason, $config[TemplateBPStore::SeasonId])) {
            return ClientErrorCode::SHOP_ZL_ITEM_NOT_FOUND;
        }
        //检查赛季状态
        if ($this->getSeasonStatus() == GameConstantDefine::SEASON_STATUS_CLOSE) {
            return ClientErrorCode::SEASON_CLOSE;
        }
        //检查限购
        /**
         * @var ShopZLModel $shopZLModel
         */
        $shopZLModel = ModelManager::getInstance()->getModel(ModelTypeDefine::SHOP_ZL);
        $hasBuyNum = $shopZLModel->getHasBuyNum($id);
        if ($hasBuyNum + $num > $config[TemplateBPStore::MaxNum]) {
            return ClientErrorCode::SHOP_ZL_BUY_NUM_OVER_LIMIT;
        }
        $this->setLogConsumeItemSource(GameConstantDefine::ITEM_CONSUME_SOURCE_BUY_ZL_SHOP);
        $this->setLogAddItemSource(GameConstantDefine::ITEM_ADD_SOURCE_ZL_SHOP);
        //检查货币
        $price = $config[TemplateBPStore::Price] * $num;
        if (false == $this->subMoney($config[TemplateBPStore::ConvertedType], $price)) {
            return $this->getMoneyNotEnoughCode($config[TemplateBPStore::ConvertedType]);
        }
        //加道具
        $this->gainItem(
            $config[TemplateBPStore::ItemId],
            $config[TemplateBPStore::Num] * $num,
        );
        //更新购买数量
        $data = array(
            $id => $hasBuyNum + $num
        );
        $shopZLModel->updateBuyNum($data);
        //更新消息
        $shopZLModel->addSendShopItem($data);
        //触发购买道具任务
        $param = array(
            GameConstantDefine::EVENT_KEY_ITEM_ID => $config[TemplateBPStore::ItemId],
            GameConstantDefine::EVENT_KEY_NUM => $num,
        );
        $this->triggerEvent(EventTypeDefine::EVENT_TYPE_TASK_SHOP_BUY_ITEM, $param);
        return ClientErrorCode::CLIENT_SUCCESS;
    }

    //购买道具变化消息
    public function getSendShopItem(): array
    {
        /**
         * @var ShopZLModel $shopZLModel
         */
        $shopZLModel = ModelManager::getInstance()->getModel(ModelTypeDefine::SHOP_ZL);
        return $shopZLModel->getSendShopItem();
    }
}
