<?php

/**
 * 赛季商城
 */

namespace Game\Logic\Shop;

use Framework\Logic\TemplateHelp;
use Framework\MVC\ModelManager;
use Game\Constant\ClientErrorCode;
use Game\Constant\ConstTemplate\TemplateSeasonStore;
use Game\Constant\EventTypeDefine;
use Game\Constant\GameConstantDefine;
use Game\Constant\ModelTypeDefine;
use Game\Constant\TemplateDefine;
use Game\Logic\EventLogic;
use Game\Logic\ItemLogic;
use Game\Logic\MoneyLogic;
use Game\Logic\SeasonLogic;
use Game\Model\Shop\ShopSeasonModel;

trait ShopSeasonLogic
{
    use TemplateHelp;
    use MoneyLogic;
    use ItemLogic;
    use EventLogic;
    use SeasonLogic;

    //购买赛季商城道具
    public function buyShopSeasonItem(int $id, int $num): int
    {
        if ($num <= 0) {
            return ClientErrorCode::SHOP_BUY_NUM_ERROR;
        }
        $config = $this->getTitle(TemplateDefine::TYPE_SHOP_SEASON, $id);
        if (is_null($config)) {
            return ClientErrorCode::SHOP_SEASON_ITEM_NOT_FOUND;
        }
        //检查赛季
        $nowSeason = $this->getSeasonId();
        if (!in_array($nowSeason, $config[TemplateSeasonStore::SeasonId])) {
            return ClientErrorCode::SHOP_SEASON_ITEM_NOT_FOUND;
        }
        //检查赛季状态
        if ($this->getSeasonStatus() == GameConstantDefine::SEASON_STATUS_CLOSE) {
            return ClientErrorCode::SEASON_CLOSE;
        }
        //检查限购
        // 不限购
        if($config[TemplateSeasonStore::MaxNum] !== 0) {
            /**
             * @var ShopSeasonModel $shopSeasonModel
             */
            $shopSeasonModel = ModelManager::getInstance()->getModel(ModelTypeDefine::SHOP_SEASON);
            $hasBuyNum = $shopSeasonModel->getHasBuyNum($id);
            if ($hasBuyNum + $num > $config[TemplateSeasonStore::MaxNum]) {
                return ClientErrorCode::SHOP_SEASON_BUY_NUM_OVER_LIMIT;
            }
        }

        $this->setLogConsumeItemSource(GameConstantDefine::ITEM_CONSUME_SOURCE_BUY_SEASON_SHOP);
        $this->setLogAddItemSource(GameConstantDefine::ITEM_ADD_SOURCE_SEASON_SHOP);
        //检查货币
        $price = $config[TemplateSeasonStore::Price] * $num;
        if (false == $this->subMoney($config[TemplateSeasonStore::ConvertedType], $price)) {
            return $this->getMoneyNotEnoughCode($config[TemplateSeasonStore::ConvertedType]);
        }
        //加道具
        $this->gainItem(
            $config[TemplateSeasonStore::ItemId],
            $config[TemplateSeasonStore::Num] * $num,
        );
        //更新购买数量
        $data = array(
            $id => $hasBuyNum + $num
        );
        $shopSeasonModel->updateBuyNum($data);
        //更新消息
        $shopSeasonModel->addSendShopItem($data);
        //触发购买道具任务
        $param = array(
            GameConstantDefine::EVENT_KEY_ITEM_ID => $config[TemplateSeasonStore::ItemId],
            GameConstantDefine::EVENT_KEY_NUM => $num,
        );
        $this->triggerEvent(EventTypeDefine::EVENT_TYPE_TASK_SHOP_BUY_ITEM, $param);
        return ClientErrorCode::CLIENT_SUCCESS;
    }

    //购买道具变化消息
    public function getSendShopItem(): array
    {
        /**
         * @var ShopSeasonModel $shopSeasonModel
         */
        $shopSeasonModel = ModelManager::getInstance()->getModel(ModelTypeDefine::SHOP_SEASON);
        return $shopSeasonModel->getSendShopItem();
    }
}
