<?php

/**
 * 推荐商店
 */

namespace Game\Logic\Shop;

use Framework\Lib\Utils;
use Framework\Logic\TemplateHelp;
use Game\Constant\ClientErrorCode;
use Game\Constant\ConstTemplate\TemplateShopRecommend;
use Game\Constant\GameConstantDefine;
use Game\Constant\TemplateDefine;
use Game\Logic\ItemLogic;
use Game\Logic\MoneyLogic;

trait ShopRecommendLogic
{
    use TemplateHelp;
    use ItemLogic;
    use MoneyLogic;

    public function buyShopRecommend(int $id, int $num): int
    {
        //关闭推荐商城购买,转到对应商城购买
        return ClientErrorCode::SHOP_RECOMMEND_NOT_FOUND;
        if ($num <= 0) {
            return ClientErrorCode::SHOP_BUY_NUM_ERROR;
        }
        $config = $this->getTitle(TemplateDefine::TYPE_SHOP_RECOMMEND, $id);
        if (is_null($config)) {
            return ClientErrorCode::SHOP_RECOMMEND_NOT_FOUND;
        }
        //检查上下架时间
        $now = Utils::getServerTimestamp();
        if ($now < $config[TemplateShopRecommend::StartTime]) {
            return ClientErrorCode::SHOP_RECOMMEND_ITEM_NOT_IN_TIME;
        }
        if ($now > $config[TemplateShopRecommend::EndTime]) {
            return ClientErrorCode::SHOP_RECOMMEND_ITEM_OUT_TIME;
        }
        //检查购买类型
        if ($config[TemplateShopRecommend::Access] != 0) {
            return ClientErrorCode::SHOP_RECOMMEND_CAN_NOT_BUY;
        }
        //检查货币
//        $hasMoney = $this->getMoney($config[TemplateShopRecommend::ConvertedType]);
//        $needMoney = $config[TemplateShopRecommend::Price] * $num;
//        if ($hasMoney < $needMoney) {
//            return $this->getMoneyNotEnoughCode($config[TemplateShopRecommend::ConvertedType]);
//        }
        //记录消耗来源
        $this->setLogConsumeItemSource(GameConstantDefine::ITEM_CONSUME_SOURCE_SHOP_RECOMMEND);
        $this->setLogAddItemSource(GameConstantDefine::ITEM_ADD_SOURCE_SHOP_RECOMMEND);
//        $this->subMoney($config[TemplateShopRecommend::ConvertedType], $needMoney);
        //加道具
        $addItems = array();
        foreach ($config[TemplateShopRecommend::ItemId] as $itemId) {
            isset($addItems[$itemId]) ? $addItems[$itemId] += $num : $addItems[$itemId] = $num;
        }
        $this->gainItemArr($addItems);
        return ClientErrorCode::CLIENT_SUCCESS;
    }
}
