<?php

/**
 * 道具商城
 */

namespace Game\Logic\Shop;

use Framework\Lib\Utils;
use Framework\MVC\ModelManager;
use Framework\Logic\TemplateHelp;
use Game\Constant\ClientErrorCode;
use Game\Constant\ConstTemplate\TemplateGoodsShop;
use Game\Constant\EventTypeDefine;
use Game\Constant\GameConstantDefine;
use Game\Constant\ModelTypeDefine;
use Game\Constant\TemplateDefine;
use Game\Logic\EventLogic;
use Game\Logic\ItemLogic;
use Game\Logic\MoneyLogic;
use Game\Model\Shop\ShopItemModel;

trait ShopItemLogic
{
    use TemplateHelp;
    use MoneyLogic;
    use ItemLogic;
    use EventLogic;

    //购买道具商城道具
    public function buyShopItem(int $id, int $num): int
    {
        if ($num <= 0) {
            return ClientErrorCode::SHOP_BUY_NUM_ERROR;
        }
        $config = $this->getTitle(TemplateDefine::TYPE_SHOP_ITEM, $id);
        if (is_null($config)) {
            return ClientErrorCode::SHOP_ITEM_NOT_FOUND;
        }
        //检查当前批次
        /**
         * @var ShopItemModel $shopItemModel
         */
        $shopItemModel = ModelManager::getInstance()->getModel(ModelTypeDefine::SHOP_ITEM);
        //检查上下架时间
        $now = Utils::getServerTimestamp();
        if ($now < $config[TemplateGoodsShop::StartTime]) {
            return ClientErrorCode::SHOP_ITEM_NOT_IN_TIME;
        }
        if ($now > $config[TemplateGoodsShop::EndTime]) {
            return ClientErrorCode::SHOP_ITEM_OUT_TIME;
        }
        //检查限购
        $hasBuyNum = 0;
        if (in_array($config[TemplateGoodsShop::ShowType], TemplateGoodsShop::BUY_LIMIT_TYPE)) {
            $hasBuyNum = $shopItemModel->getHasBuyNum($id);
            if ($hasBuyNum + $num > $config[TemplateGoodsShop::MaxNum]) {
                return ClientErrorCode::SHOP_BUY_NUM_OVER_LIMIT;
            }
        }
        $this->setLogConsumeItemSource(GameConstantDefine::ITEM_CONSUME_SOURCE_BUY_ITEM_SHOP);
        $this->setLogAddItemSource(GameConstantDefine::ITEM_ADD_SOURCE_ITEM_SHOP);
        //检查货币
        $price = $config[TemplateGoodsShop::RealPrice] * $num;
        if (false == $this->subMoney($config[TemplateGoodsShop::ConvertedType], $price)) {
            return $this->getMoneyNotEnoughCode($config[TemplateGoodsShop::ConvertedType]);
        }
        //加道具
        $this->gainItem($config[TemplateGoodsShop::ItemId], $config[TemplateGoodsShop::Num] * $num);
        //更新购买数量
        if (in_array($config[TemplateGoodsShop::ShowType], TemplateGoodsShop::BUY_LIMIT_TYPE)) {
            $hasBuyNum += $num;
            $data = array(
                $id => $hasBuyNum
            );
            $shopItemModel->updateBuyNum($data);
        }
        //更新消息
        $shopItemModel->addSendShopItem(array($id => $hasBuyNum));
        //商店购买道具
        $param = array(
            GameConstantDefine::EVENT_KEY_ITEM_ID => $config[TemplateGoodsShop::ItemId],
            GameConstantDefine::EVENT_KEY_NUM => $num,
        );
        $this->triggerEvent(EventTypeDefine::EVENT_TYPE_TASK_SHOP_BUY_ITEM, $param);
        return ClientErrorCode::CLIENT_SUCCESS;
    }

    //购买道具变化消息
    public function getSendShopItem(): array
    {
        /**
         * @var ShopItemModel $shopItemModel
         */
        $shopItemModel = ModelManager::getInstance()->getModel(ModelTypeDefine::SHOP_ITEM);
        return $shopItemModel->getSendShopItem();
    }
}
