<?php

/**
 * 购买服装商城服装
 */

namespace Game\Logic\Shop;

use Framework\Lib\Utils;
use Framework\Log\LogMark;
use Framework\MVC\ModelManager;
use Framework\Logic\TemplateHelp;
use Game\Constant\ClientErrorCode;
use Game\Constant\ConstTemplate\TemplateItem;
use Game\Constant\ConstTemplate\TemplateShopClothing;
use Game\Constant\EventTypeDefine;
use Game\Constant\GameConstantDefine;
use Game\Constant\TemplateDefine;
use Game\Logic\ClothLogic;
use Game\Logic\EventLogic;
use Game\Logic\ItemLogic;
use Game\Logic\MoneyLogic;

trait ShopClothingLogic
{
    use TemplateHelp;
    use MoneyLogic;
    use ItemLogic;
    use ClothLogic;
    use EventLogic;

    //购买服装,购买成功的穿上
    public function buyShopClothing($shopItemIds, int $couponId, int $playerId): int
    {
        $buyItemIds = array(); //可购买的商品 shopId=>item表Id
        $now = Utils::getServerTimestamp();
        //道具校验
        $config = $this->getTable(TemplateDefine::TYPE_SHOP_CLOTHING);
        foreach ($shopItemIds as $shopItemId) {
            if (!array_key_exists($shopItemId, $config)) {
                return ClientErrorCode::SHOP_CLOTHING_ITEM_NOT_FOUND;
            }
            //检查时间
            if ($now < $config[$shopItemId][TemplateShopClothing::StartTime]) {
                return ClientErrorCode::SHOP_CLOTHING_ITEM_NOT_IN_TIME;
            }
            if ($now > $config[$shopItemId][TemplateShopClothing::EndTime]) {
                return ClientErrorCode::SHOP_CLOTHING_ITEM_OUT_TIME;
            }
            //新品不能购买
            if ($config[$shopItemId][TemplateShopClothing::ShowType] != TemplateShopClothing::SHOW_TYPE_NEW) {
                $buyItemIds[$shopItemId] = $config[$shopItemId][TemplateShopClothing::ItemId];
            }
        }
        if (empty($buyItemIds)) {
            return ClientErrorCode::SHOP_CLOTHING_ITEM_CAN_NOT_BUY;
        }
        //检查是否已有此服装,扣除已拥有的
        $shopItemIdToCloth = array();   //shopId =>[clothId,..]
        foreach ($buyItemIds as $shopItemId => $itemId) {
            $itemConfig = $this->getTitle(TemplateDefine::TYPE_ITEM, $itemId);
            if (is_null($itemConfig)) {
                LogMark::getInstance()->markDebug(
                    "[ShopClothingLogic] ShopClothing ItemId error,not found int item table",
                    array(
                        "ShopClothingId" => $shopItemId,
                        "itemId" => $itemId
                    )
                );
                return ClientErrorCode::SHOP_CLOTHING_ITEM_CAN_NOT_BUY;
            }
            //套装
            if ($itemConfig[TemplateItem::ShowType] == TemplateItem::SHOW_TYPE_CLOTHING_SUIT) {
                foreach ($itemConfig[TemplateItem::ClothList] as $id) {
                    if ($this->getItemNumByTplID($id) > 0) {
                        //已有此服装
                        return ClientErrorCode::SHOP_CLOTHING_HAS_CLOTHING;
                    }
                    $shopItemIdToCloth[$shopItemId][] = $id;
                }
            } else {
                //单件
                if ($this->getItemNumByTplID($itemId) > 0) {
                    //已有此服装
                    return ClientErrorCode::SHOP_CLOTHING_HAS_CLOTHING;
                }
                $shopItemIdToCloth[$shopItemId] = [$itemId];
            }
        }
        if (empty($shopItemIdToCloth)) {
            return ClientErrorCode::SHOP_CLOTHING_HAS_CLOTHING;
        }
        //计算需要货币
        $needMoneyArray = array();  //货币类型=>数量
        $addClothArray = array();
        foreach ($shopItemIdToCloth as $shopItemId => $clothArr) {
            isset($needMoneyArray[$config[$shopItemId][TemplateShopClothing::ConvertedType]]) ?
                $needMoneyArray[$config[$shopItemId][TemplateShopClothing::ConvertedType]] += $config[$shopItemId][TemplateShopClothing::RealPrice] :
                $needMoneyArray[$config[$shopItemId][TemplateShopClothing::ConvertedType]] = $config[$shopItemId][TemplateShopClothing::RealPrice];
            foreach ($clothArr as $clothId) {
                $addClothArray[$clothId] = 1;
            }
        }
        //TODO:优惠券使用
        $discount = 1;
        //检查货币
        foreach ($needMoneyArray as $moneyType => $price) {
            if ($this->getMoney($moneyType) < $price) {
                return $this->getMoneyNotEnoughCode($moneyType);
            }
        }
        $this->setLogAddItemSource(GameConstantDefine::ITEM_ADD_SOURCE_CLOTH_SHOP);
        $this->setLogConsumeItemSource(GameConstantDefine::ITEM_CONSUME_SOURCE_BUY_CLOTH_SHOP);
        //扣钱加服装
        $this->subMoneyList($needMoneyArray);
        //TODO:扣除优惠券
        $this->gainItemArr($addClothArray);
        //穿上新购买的服装
        $this->wearNewClothInShop($playerId, array_keys($addClothArray));
        //商店购买道具
        foreach ($shopItemIds as $shopItemId) {
            $param = array(
                GameConstantDefine::EVENT_KEY_ITEM_ID => $config[$shopItemId][TemplateShopClothing::ItemId],
                GameConstantDefine::EVENT_KEY_NUM => 1,
            );
            $this->triggerEvent(EventTypeDefine::EVENT_TYPE_TASK_SHOP_BUY_ITEM, $param);
        }
        return ClientErrorCode::CLIENT_SUCCESS;
    }
}