<?php

/**
 * 赛车商城
 */

namespace Game\Logic\Shop;

use Framework\Lib\Utils;
use Framework\Log\LogMark;
use Framework\MVC\ModelManager;
use Framework\Logic\TemplateHelp;
use Game\Constant\ClientErrorCode;
use Game\Constant\ConstTemplate\TemplateShopCar;
use Game\Constant\EventTypeDefine;
use Game\Constant\GameConstantDefine;
use Game\Constant\GameErrorCode;
use Game\Constant\ModelTypeDefine;
use Game\Constant\TemplateDefine;
use Game\Logic\CarLogic;
use Game\Logic\ItemLogic;
use Game\Logic\MoneyLogic;
use Game\Model\Car\CarExteriorRefitModel;

trait ShopCarLogic
{
    use TemplateHelp;
    use MoneyLogic;
    use ItemLogic;
    use CarLogic;

    //购买赛车商城道具
    public function buyShopCarItem(int $id, int $couponId, string $params): int
    {
        //检查道具是否存在
        $config = $this->getTitle(TemplateDefine::TYPE_SHOP_CAR, $id);
        if (is_null($config)) {
            return ClientErrorCode::SHOP_CAR_ITEM_NOT_FOUND;
        }
        //新手引导送车
        if ($id == TemplateShopCar::NEW_PLAYER_GUIDE_ID) {
            return $this->newPlayerGuideSendCar($config);
        }
        //检查上下架时间
        $now = Utils::getServerTimestamp();
        if ($now < $config[TemplateShopCar::StartTime]) {
            return ClientErrorCode::SHOP_CAR_ITEM_NOT_IN_TIME;
        }
        if ($now > $config[TemplateShopCar::EndTime]) {
            return ClientErrorCode::SHOP_CAR_ITEM_OUT_TIME;
        }
        //检查显示类型,新品不能购买
        if ($config[TemplateShopCar::ShowType] == TemplateShopCar::SHOW_TYPE_NEW) {
            return ClientErrorCode::SHOP_CAR_ITEM_CAN_NOT_BUY;
        }
        $this->setLogConsumeItemSource(GameConstantDefine::ITEM_CONSUME_SOURCE_BUY_CAR_SHOP);
        $this->setLogAddItemSource(GameConstantDefine::ITEM_ADD_SOURCE_CAR_SHOP);
        //TODO:优惠券检查
        $discount = 1;
        //检查货币
        $price = $config[TemplateShopCar::RealPrice] * $discount;
        $hasMoney = $this->getMoney($config[TemplateShopCar::ConvertedType]);
        if ($hasMoney < $price) {
            return $this->getMoneyNotEnoughCode($config[TemplateShopCar::ConvertedType]);
        }
        if ($config[TemplateShopCar::UseType] == TemplateShopCar::USE_TYPE_CAR) {
            //检查是否已拥有赛车
            $carId = $config[TemplateShopCar::CheckItemId];
            $car = $this->searchCarDataByCarID($carId);
            if (!is_null($car)) {
                //检查是否为限时车
                if ($car->expire == 0) {
                    return ClientErrorCode::SHOP_CAR_HAS_CAR;
                }
            }
        }
        //买道具
        if(!$this->gainItem($config[TemplateShopCar::ItemId], 1)) {
            return ClientErrorCode::SHOP_CAR_BUY_FAIL;
        }
        //扣钱
        $this->subMoney($config[TemplateShopCar::ConvertedType], $price);
        //TODO:扣优惠券
//        subItemByTIDArr
        //商店购买道具
        $param = array(
            GameConstantDefine::EVENT_KEY_ITEM_ID => $config[TemplateShopCar::ItemId],
            GameConstantDefine::EVENT_KEY_NUM => 1,
        );
        $this->triggerEvent(EventTypeDefine::EVENT_TYPE_TASK_SHOP_BUY_ITEM, $param);
        return ClientErrorCode::CLIENT_SUCCESS;
    }

    //新手引导送车
    //不检查时间和消耗 直接送车
    private function newPlayerGuideSendCar(array $config): int
    {
        //检查是否已拥有赛车
        $carId = $config[TemplateShopCar::CheckItemId];
        $car = $this->searchCarDataByCarID($carId);
        //检查是否为限时车
        if (!is_null($car) && $car->expire == 0) {
            return ClientErrorCode::SHOP_CAR_HAS_CAR;
        }
        //买车
        if(!$this->gainItem($config[TemplateShopCar::ItemId], 1)) {
            return ClientErrorCode::SHOP_CAR_BUY_FAIL;
        }
        return ClientErrorCode::CLIENT_SUCCESS;
    }
}
