<?php

/**
 * 赛季信息统计
 */

namespace Game\Logic;

use Framework\MVC\ModelManager;
use Game\Constant\GameConstantDefine;
use Game\Constant\ModelTypeDefine;
use Game\Data\SeasonStatisticsData;
use Game\Model\Season\SeasonStatisticsModel;
use Game\Protobuf\GCStatisticsInfo;

trait SeasonStatisticsLogic
{
    //获取赛季统计信息
    /**
     * @param int $mode     模式: 0所有对局,1排位赛,2练习赛
     * @param int $season   赛季选择: 0本赛季,1全部赛季
     * @return GCStatisticsInfo
     */
    public function getSeasonStatistics(int $mode, int $season): GCStatisticsInfo
    {
        /**
         * @var SeasonStatisticsModel $ssModel
         */
        $ssModel = ModelManager::getInstance()->getModel(ModelTypeDefine::SEASON_STATISTICS);
        if ($mode == 0) {
            return $this->getAllStatistics($ssModel, $season);
        }
        return $this->tidyDataToGCStatisticsInfo($ssModel->getSeasonStatistics($mode), $season);
    }

    //获取所有对局
    private function getAllStatistics(SeasonStatisticsModel $ssModel, int $season): GCStatisticsInfo
    {
        //获取排位 联系统计数据
        $rankingData = $ssModel->getSeasonStatistics(SeasonStatisticsData::TITLE_RANKING);
        $practiceData = $ssModel->getSeasonStatistics(SeasonStatisticsData::TITLE_PRACTICE);
        //数据相加
        $data = array();
        foreach ($rankingData as $key => $value) {
            $data[$key] = $practiceData[$key] + $value;
        }
        return $this->tidyDataToGCStatisticsInfo($data, $season);
    }

    //整理数据为GCStatisticsInfo
    private function tidyDataToGCStatisticsInfo(array $data, int $season): GCStatisticsInfo
    {
        $statisticsInfo = new GCStatisticsInfo();
        if ($season == 0) {
            //本赛季
            $statisticsInfo->setNum($data[SeasonStatisticsData::NS_NUM]);
            $statisticsInfo->setWinNum($data[SeasonStatisticsData::NS_WIN_NUM]);
            $statisticsInfo->setRacePositionNum($data[SeasonStatisticsData::NS_RACE_POSITION_NUM]);
            $statisticsInfo->setJamPositionNum($data[SeasonStatisticsData::NS_JAM_POSITION_NUM]);
            $statisticsInfo->setHelpPositionNum($data[SeasonStatisticsData::NS_HELP_POSITION_NUM]);
            $statisticsInfo->setMvpNum($data[SeasonStatisticsData::NS_MVP_NUM]);
            $statisticsInfo->setIconRaceNum($data[SeasonStatisticsData::NS_ICON_RACE_NUM]);
            $statisticsInfo->setIconJamNum($data[SeasonStatisticsData::NS_ICON_JAM_NUM]);
            $statisticsInfo->setIconHelpNum($data[SeasonStatisticsData::NS_ICON_HELP_NUM]);
            $statisticsInfo->setNo1Num($data[SeasonStatisticsData::NS_NO1_NUM]);
            $statisticsInfo->setNo2Num($data[SeasonStatisticsData::NS_NO2_NUM]);
            $statisticsInfo->setNo3Num($data[SeasonStatisticsData::NS_NO3_NUM]);
            return $statisticsInfo;
        }
        //全部赛季
        $statisticsInfo->setNum($data[SeasonStatisticsData::AS_NUM]);
        $statisticsInfo->setWinNum($data[SeasonStatisticsData::AS_WIN_NUM]);
        $statisticsInfo->setRacePositionNum($data[SeasonStatisticsData::AS_RACE_POSITION_NUM]);
        $statisticsInfo->setJamPositionNum($data[SeasonStatisticsData::AS_JAM_POSITION_NUM]);
        $statisticsInfo->setHelpPositionNum($data[SeasonStatisticsData::AS_HELP_POSITION_NUM]);
        $statisticsInfo->setMvpNum($data[SeasonStatisticsData::AS_MVP_NUM]);
        $statisticsInfo->setIconRaceNum($data[SeasonStatisticsData::AS_ICON_RACE_NUM]);
        $statisticsInfo->setIconJamNum($data[SeasonStatisticsData::AS_ICON_JAM_NUM]);
        $statisticsInfo->setIconHelpNum($data[SeasonStatisticsData::AS_ICON_HELP_NUM]);
        $statisticsInfo->setNo1Num($data[SeasonStatisticsData::AS_NO1_NUM]);
        $statisticsInfo->setNo2Num($data[SeasonStatisticsData::AS_NO2_NUM]);
        $statisticsInfo->setNo3Num($data[SeasonStatisticsData::AS_NO3_NUM]);
        return $statisticsInfo;
    }

    //比赛结束--更新赛季信息
    public function updateSeasonStatistics(array $data, int $matchType)
    {
        if(!in_array($matchType, GameConstantDefine::SEASON_STATISTICS_MAP)) {
            return ;
        }
        $title = $this->getTitleKey($matchType);
        /**
         * @var SeasonStatisticsModel $ssModel
         */
        $ssModel = ModelManager::getInstance()->getModel(ModelTypeDefine::SEASON_STATISTICS);
        //获取全部数据
        $ssdData = $ssModel->getSeasonStatistics($title);
        $updateData = array(
            //比赛次数
            SeasonStatisticsData::NS_NUM => $ssdData[SeasonStatisticsData::NS_NUM] + 1,
            SeasonStatisticsData::AS_NUM => $ssdData[SeasonStatisticsData::AS_NUM] + 1,
        );
        foreach ($data as $key => $value) {
            //更新数据
            $tmpValue = $ssdData[$key] + $value;
            $updateData[$key] = $tmpValue;
            //完成当前赛季数据 同步更新全部赛季对应数据
            $sameKey = $ssModel->getSameKey($key);
            if (!is_null($sameKey)) {
                $updateData[$sameKey] = $tmpValue;
            }
        }
        $ssModel->saveSeasonStatistics($updateData, $title);
    }

    //根据比赛模式,返回title
    private function getTitleKey(int $matchType): int
    {
        switch ($matchType)
        {
            case GameConstantDefine::MATCH_MODE_SINGLE_PRACTISE:
            case GameConstantDefine::MATCH_MODE_TEAM_PRACTISE:
                return SeasonStatisticsData::TITLE_PRACTICE;
            case GameConstantDefine::MATCH_MODE_SINGLE_PAI_WEI:
            case GameConstantDefine::MATCH_MODE_TEAM_PAI_WEI:
                return SeasonStatisticsData::TITLE_RANKING;
        }
        return SeasonStatisticsData::TITLE_RANKING;
    }
}