<?php

/**
 * 新手引导假匹配
 */

namespace Game\Logic\Pvp;

use Framework\Logic\TemplateHelp;
use Framework\MVC\ModelManager;
use Game\Constant\ConstTemplate\TemplateGuideAI;
use Game\Constant\EventTypeDefine;
use Game\Constant\GameConstantDefine;
use Game\Constant\ModelTypeDefine;
use Game\Constant\TemplateDefine;
use Game\Data\AccountData;
use Game\Data\RecordData;
use Game\Data\RoomData;
use Game\Logic\EventLogic;
use Game\Model\Pvp\PvpBaseModel;
use Game\Model\RecordModel;
use Game\Model\RoomModel;
use Game\Protobuf\AIInfo;
use Game\Protobuf\ClothData;
use Game\Protobuf\GCGuideMatching;
use Game\Protobuf\PlayerInfo;

trait GuideJoinMatchLogic
{
    use TemplateHelp;
    use PvpMatchLogic;
    use EventLogic;

    //新手引导假匹配,直接返回匹配结果
    public function getGuideJoinMatchingJoinId(int $matchNum): int
    {
        [$mapId, $matchType] = $this->getGuideMatchConfigByNum($matchNum);
        //生成RoomData
        /**
         * @var RoomModel $roomModel
         */
        $roomModel = ModelManager::getInstance()->getModel(ModelTypeDefine::ROOM);
        $roomData = $roomModel->makeRoomData($matchNum, $mapId, $matchType, "", RoomModel::ROOM_STATE_PRIVATE);
        /**
         * @var PvpBaseModel $pvp
         */
        $pvp = ModelManager::getInstance()->getModel(ModelTypeDefine::PVP_BASE);
        //生成joinId,初始比赛信息
        return $pvp->initGuideJoinIdData($roomData, $mapId);
    }

    //根据场次,获取地图,模式
    public function getGuideMatchConfigByNum(int $matchNum): array
    {
        //第一场,个人练习赛
        if ($matchNum == 1) {
            return array(
                TemplateGuideAI::GUIDE_MATCH_1_MAP,
                GameConstantDefine::MATCH_MODE_SINGLE_PRACTISE
            );
        }
        return array(
            TemplateGuideAI::GUIDE_MATCH_2_MAP,
            GameConstantDefine::MATCH_MODE_TEAM_PRACTISE
        );
    }

    //获取个人匹配信息
    public function getGuideMatchPlayerInfo(int $playerId, int $matchNum): array
    {
        $showPlayer = $this->getMatchShowPlayer($playerId);
        $showCar = $this->getMatchShowCar($showPlayer[RoomData::CAR_TPL_ID]);
        $clothData = new ClothData();
        $clothData->mergeFromJsonString($showPlayer[RoomData::CLOTH]);
        $playerInfo = new PlayerInfo();
        $playerInfo->setPlayerId($playerId)
            ->setNickName($showPlayer[RoomData::NICK_NAME])
            ->setHead($showPlayer[RoomData::HEAD])
            ->setCarTplId($showPlayer[RoomData::CAR_TPL_ID])
            ->setExteriorRefit($showCar[RoomData::EXTERIOR_REFIT])
            ->setGender($showPlayer[RoomData::GENDER])
            ->setCloth($clothData)
            ->setProficiencyLv($showCar[RoomData::PROFICIENCY_LV])
            ->setProficiency($showCar[RoomData::PROFICIENCY])
            ->setRoleType(1)
            ->setSkinColor($showPlayer[AccountData::DB_SKIN_COLOR])
            ->setCarLv($showCar[RoomData::CAR_LV])
            ->setLevel($showPlayer[RoomData::PLAYER_LEVEL])
            ->setDan($showPlayer[RoomData::PLAYER_DAN]);
        if ($matchNum == 2) {
            $playerInfo->setGroupID(1);
        }
        return [$playerInfo];
    }

    //根据场次,获取AI信息
    public function getGuideMatchAIInfoByNum(int $matchNum): array
    {
        $aiArr = array();
        //第一场,个人练习赛
        if ($matchNum == 1) {
            foreach (TemplateGuideAI::GUIDE_MATCH_1_AI as $aiId) {
                $aiArr[] = $this->getAIInfo($aiId);
            }
            return $aiArr;
        }
        //第二场组队练习
        foreach (TemplateGuideAI::GUIDE_MATCH_2_MY_AI as $aiId) {
            $aiInfo = $this->getAIInfo($aiId);
            $aiInfo->setGroupID(1);
            $aiArr[] = $aiInfo;
        }
        //对方队伍
        foreach (TemplateGuideAI::GUIDE_MATCH_2_TARGET_AI as $aiId) {
            $aiInfo = $this->getAIInfo($aiId);
            $aiInfo->setGroupID(2);
            $aiArr[] = $aiInfo;
        }
        return $aiArr;
    }

    private function getAIInfo(int $id): AIInfo
    {
        $config = $this->getTitle(TemplateDefine::TYPE_GUIDE_AI, $id);
        $aiInfo = new AIInfo();
        $cloth = new ClothData();
        $cloth->mergeFromJsonString($config[TemplateGuideAI::ClothProtoJson]);
        //TODO:头像 暂时都是1
        $aiInfo->setPlayerId($id * 100)
            ->setAITplId($id)
            ->setNickName($config[TemplateGuideAI::Nickname])
            ->setHead(1)
            ->setGender($config[TemplateGuideAI::Sex])
            ->setCarTplId($config[TemplateGuideAI::CarId])
            ->setCarLevel($config[TemplateGuideAI::CarLevel])
            ->setExteriorRefit("[]")
            ->setCloth($cloth)
            ->setRefit("[]")
            ->setProficiencyLv(1)
            ->setProficiency(0)
            ->setSkinColor($config[TemplateGuideAI::SkinColor])
            ->setLevel(1)
            ->setDan(1);
        return $aiInfo;
    }

    //更新记录和任务
    public function updateRecordAndTask(int $playerId, GCGuideMatching $message)
    {
        //更新记录
        $changeData = array(
            RecordData::MAP_ID => $message->getSceneId(),
            RecordData::MATCH_UID => $message->getJoinId(),
            RecordData::MATCHING_DATA => $message->serializeToJsonString()
        );
        /**
         * @var RecordModel $recordModel
         */
        $recordModel = ModelManager::getInstance()->getModel(ModelTypeDefine::RECORD);
        $recordModel->updateRecordData($message->getJoinId(), $changeData);
        //触发任务
        $param = array(
            GameConstantDefine::EVENT_KEY_MATCH_MAP => $message->getSceneId(),
            GameConstantDefine::EVENT_KEY_MATCH_TYPE => $message->getMatchType(),
            GameConstantDefine::EVENT_KEY_CAR_ID => $message->getPInfo()[0]->getCarTplId(),
        );
        $this->triggerEvent(EventTypeDefine::EVENT_TYPE_TASK_JOIN_MATCH, $param);
    }
}
