<?php

/**
 * 技巧教学
 */

namespace Game\Logic\PVE;

use Framework\MVC\ModelManager;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Constant\ConstTemplate\TemplateInitPlayer;
use Game\Constant\ConstTemplate\TemplateTale;
use Game\Constant\GameConstantDefine;
use Game\Constant\ModelTypeDefine;
use Game\Data\PVE\LevelData;
use Game\Data\PVE\TeachingSkillChapterData;
use Game\Logic\ItemLogic;
use Game\Model\PVE\PveModel;
use Game\Protobuf\GCTeachingSkillChapter;
use Game\Protobuf\PacketId;

trait TeachingSkillLogic
{
    use ItemLogic;
    use DrivingLicenseLogic;

    //获取技巧教学章节信息
    public function getTeachingSkillChapter(int $chapterId): TeachingSkillChapterData
    {
        /**
         * @var PveModel $pveModel
         */
        $pveModel = ModelManager::getInstance()->getModel(ModelTypeDefine::PVE);
        return $pveModel->getTeachingSkillChapterData($chapterId);
    }

    //章节和关卡更新消息
    public function sendTeachingSkillChapterLevelMessage(int $chapterId)
    {
        $chapterMessage = new GCTeachingSkillChapter();
        /**
         * @var PveModel $pveModel
         */
        $pveModel = ModelManager::getInstance()->getModel(ModelTypeDefine::PVE);
        $chapterMessage->setLevel(
            $this->formatChapterAllLevelMessage(
                $pveModel->getAllTeachingSkillLevelData($chapterId)
            )
        );
        SendMessage::getInstance()->sendClient(PacketId::GC_TeachingSkillChapter, $chapterMessage);
    }

    //关卡检查--进入场景和结算时检查
    public function checkTeachingSkillLevel(int $levelId): int
    {
        /**
         * @var PveModel $pveModel
         */
        $pveModel = ModelManager::getInstance()->getModel(ModelTypeDefine::PVE);
        $levelData =  $pveModel->getLevelData($levelId);
        if ($levelData->levelId == 0) {
            return ClientErrorCode::PVE_LEVEL_UNLOCK;
        }

        return ClientErrorCode::CLIENT_SUCCESS;
    }

    //检查是否通关--关卡要求一次全部通关
    public function checkCompleteTeachingSkillLevel(LevelData $levelData, array $levelConfig, array $compTarget)
    {
        if (array_sum($compTarget) == 3) {
            //全部完成
            $levelData->target = "1-1-1";
            $levelData->status = LevelData::STATUS_OVER;
            //领取奖励
            $this->setLogAddItemSource(GameConstantDefine::ITEM_ADD_SOURCE_TEACH_SKILL_REWARD);
            foreach ($levelConfig[TemplateTale::Reward] as $rewardList) {
                $this->gainItemArr($rewardList);
            }
            $levelData->rewardStatus = "2-2-2"; //已领取
            $levelData->updateDB();
            //通关后检查
            $this->checkUpdateTeachingSkillLevel($levelConfig[TemplateTale::Chapters]);
        } else {
            //完成部分内容
            $levelData->target = implode("-", $compTarget);
        }
        $levelData->updateDB();
        //发送关卡更新消息
        $this->sendTeachingSkillChapterLevelMessage($levelConfig[TemplateTale::Chapters]);
    }

    //通关之后 检查是否更新驾照,开启新关卡,章节
    private function checkUpdateTeachingSkillLevel(int $chapterId)
    {
        //获取章节信息
        $chapterData = $this->getTeachingSkillChapter($chapterId);
        ++$chapterData->chapterSchedule;
        $chapterData->saveDB();
        //检查是否完成全部关卡
        $initPlayerConfig = $this->getInitPlayerConfig();
        $levelList = $initPlayerConfig[TemplateInitPlayer::TeachingSkillLevel][$chapterId];
        if ($chapterData->chapterSchedule >= count($levelList)) {
            //通关全部关卡 解锁下一级全部关卡
            $this->unlockNextTeachingSkillChapter($chapterId + 1, $initPlayerConfig);
        }
    }

    //开启新章节
    private function unlockNextTeachingSkillChapter(int $chapterId, array $initPlayerConfig)
    {
        $maxLv = count($initPlayerConfig[TemplateInitPlayer::TeachingSkillLevel]);
        if ($chapterId > $maxLv) {
            return;
        }
        /**
         * @var PveModel $pveModel
         */
        $pveModel = ModelManager::getInstance()->getModel(ModelTypeDefine::PVE);
        $pveModel->updateTeachingSkillLv($chapterId);
        $pveModel->createTeachingSkillChapter($chapterId);
        foreach ($initPlayerConfig[TemplateInitPlayer::TeachingSkillLevel][$chapterId] as $levelId) {
            $pveModel->createLevel($levelId);
        }
    }

}
