<?php

/**
 * 地图结算统计数据
 */

namespace Game\Logic;

use Framework\Logic\TemplateHelp;
use Framework\MVC\ModelManager;
use Game\Constant\ConstTemplate\TemplateCar;
use Game\Constant\ConstTemplate\TemplateConst;
use Game\Constant\GameConstantDefine;
use Game\Constant\ModelTypeDefine;
use Game\Constant\TemplateDefine;
use Game\Data\MapStatisticsData;
use Game\Model\MapStatisticsModel;
use Game\Protobuf\RecordBreakingInfo;
use Game\Protobuf\SettlementParameter;

trait MapStatisticsLogic
{
    use GenerateAiLogic;

    use TemplateHelp;


    //检查是否破记录并更新数据
    public function updateMapStatistics(
        int $playerId,
        int $matchType,
        int $carId,
        int $mapId,
        SettlementParameter $parameter,
        int $continuityWinNum,
        bool $isUpdate = true
    ): RecordBreakingInfo
    {
        $info = new RecordBreakingInfo();
        if ($this->checkIsAIPlayer($playerId)) {
            return $info;
        }

        if (!in_array($matchType, GameConstantDefine::BREAKING_RECORD_MATCH_TYPE)) {
            return $info;
        }

        //车辆定位
//        $carConfigData = $this->getTitle(TemplateDefine::TYPE_CAR, $carId);
//        $carPositioning = $carConfigData[TemplateCar::Positioning];
//        switch ($carPositioning) {
//            case TemplateCar::Positioning_Race:
//                //竞速位
//                break;
//            case TemplateCar::Positioning_Jam:
//                //干扰位
//                break;
//            case TemplateCar::Positioning_Help:
//                //辅助位
//                break;
//        }

        //依次获取 周 月 历史记录,比较 检查是否破记录
        /**
         * @var MapStatisticsModel $mapStatisticsModel
         */
        $mapStatisticsModel = ModelManager::getInstance()->getModel(ModelTypeDefine::MAP_STATISTICS);
        $statisticsData = $mapStatisticsModel->getMapStatisticsData($mapId, MapStatisticsModel::TITLE_WEEK);
        $this->checkRecordBreaking(
            $mapStatisticsModel,
            $statisticsData,
            $parameter,
            $continuityWinNum,
            $info,
            MapStatisticsData::BREAKING_FLAG_WEEK,
            $isUpdate
        );
        $statisticsData = $mapStatisticsModel->getMapStatisticsData($mapId, MapStatisticsModel::TITLE_MONTH);
        $this->checkRecordBreaking(
            $mapStatisticsModel,
            $statisticsData,
            $parameter,
            $continuityWinNum,
            $info,
            MapStatisticsData::BREAKING_FLAG_MOTH,
            $isUpdate
        );
        $statisticsData = $mapStatisticsModel->getMapStatisticsData($mapId, MapStatisticsModel::TITLE_HISTORY);
        $this->checkRecordBreaking(
            $mapStatisticsModel,
            $statisticsData,
            $parameter,
            $continuityWinNum,
            $info,
            MapStatisticsData::BREAKING_FLAG_HISTORY,
            $isUpdate
        );
        return $info;
    }

    private function checkRecordBreaking(
        MapStatisticsModel $mapStatisticsModel,
        MapStatisticsData $statisticsData,
        SettlementParameter $parameter,
        int $continuityWinNum,
        RecordBreakingInfo $info,
        int $breakFlag,
        bool $isUpdate
    ) {
        //检查数据是否破记录--平记录也算破记录
        $isChange = false;
        foreach (MapStatisticsData::DB_KEY_MAP as $key => $value) {
            if ($key == MapStatisticsData::CONTINUITY_WIN_NUM) {
                //检查连胜
                if ($continuityWinNum > 0 && $continuityWinNum >= $statisticsData->continuityWinNum) {
                    $isChange = true;
                    $info->setContinuityWinFlag($breakFlag);
                    $statisticsData->continuityWinNum = $continuityWinNum;
                }
            } elseif ($key == MapStatisticsData::COST_TIME) {
                //检查时间
                $parameterKey = "get".$key;
                $parameterValue = $parameter->$parameterKey();
                $statisticsDataValue = $statisticsData->$value;
                $infoKey = "set".$key."Flag";
                if ($statisticsDataValue == 0 && $parameterValue > 0) {
                    $isChange = true;
                    $info->$infoKey($breakFlag);
                    $statisticsData->$value = $parameterValue;
                }
                if ($parameterValue > 0 && $parameterValue <= $statisticsDataValue) {
                    $isChange = true;
                    $info->$infoKey($breakFlag);
                    $statisticsData->$value = $parameterValue;
                }
            } else {
                $parameterKey = "get".$key;
                $parameterValue = $parameter->$parameterKey();
                $statisticsDataValue = $statisticsData->$value;
                $infoKey = "set".$key."Flag";
                if ($parameterValue > 0 && $parameterValue >= $statisticsDataValue) {
                    $isChange = true;
                    $info->$infoKey($breakFlag);
                    $statisticsData->$value = $parameterValue;
                }
            }
        }
        if ($isUpdate && $isChange) {
            $mapStatisticsModel->updateMapStatisticsData($statisticsData);
        }
    }
}
