<?php
/**
 * 比赛后点赞
 * @date 2022/6/14/014
 * @author JZW
 **/

namespace Game\Logic;


use Framework\MVC\ModelManager;
use Game\Constant\ClientErrorCode;
use Game\Constant\ModelTypeDefine;
use Game\Data\RoleExtData;
use Game\Model\AccountModel;
use Game\Model\LikesModel;

trait LikesLogic
{
    public function addLikes($otherId, $matchId): int
    {
        /**
         * @var LikesModel $likes
         */
        $likes = ModelManager::getInstance()->getModel(ModelTypeDefine::LIKES);
        $likes->otherId = $otherId;
        $likes->matchId = $matchId;
        if (!$likes->addRankLikes()){
            return $likes->errorCode;
        }
        return ClientErrorCode::CLIENT_SUCCESS;
    }

    public function getLikesNum($otherId, $matchId): int
    {
        /**
         * @var LikesModel $likes
         */
        $likes = ModelManager::getInstance()->getModel(ModelTypeDefine::LIKES);
        $likes->otherId = $otherId;
        $likes->matchId = $matchId;
        return $likes->getLikesNum();
    }
}