<?php
/**
 *
 * @date 2022-3-30
 * @author JZW
 **/


namespace Game\Logic\Friend;


use Framework\MVC\ModelManager;
use Framework\Lib\Utils;
use Game\Constant\ModelTypeDefine;
use Game\Model\AccountModel;
use Game\Model\Friend\FriendRandomModel;
use Game\Data\AccountData;

trait FriendRandomLogic
{
    public function updateRandomScore(int $dan = 1)
    {
        /**
         * @var AccountModel $account
         */
        $account = ModelManager::getInstance()->getModel(ModelTypeDefine::ACCOUNT);
        $gender = $account->getAccountAttr(AccountData::DB_GENDER);
        /**
         * @var FriendRandomModel $mol_friendRandom
         */
        $mol_friendRandom = ModelManager::getInstance()->getModel(ModelTypeDefine::COMMON_FRIEND);
        $mol_friendRandom->setScore($this->getScore($gender, $dan));
        $mol_friendRandom->addData();
    }

    public function getScore($gender, $dan): int
    {
        return Utils::makeFriendsScore($gender, $dan);
    }

}