<?php
/**
 *
 * @date 2022/6/22
 * @author JZW
 **/

namespace Game\Logic;


use Framework\MVC\ModelManager;
use Game\Constant\ModelTypeDefine;
use Game\Data\EventConditionData;
use Game\Model\EventConditionModel;
use Game\Model\Rank\RankModel;

trait EventConditionLogic
{
    //生成排行榜 Key
    public function getRankingKey(int $type, int $seasonId, int $id): ?string
    {
        if (in_array($type, RankModel::RANK_TYPE)) {
            return EventConditionData::EVENT_CONDITION_KEY_RANK ."-$type#$seasonId#$id";
        }
        return null;
    }

    //赛车外观改装Key
    public function getCarExteriorRefitKey(int $carId, int $type): string
    {
        return EventConditionData::EVENT_CONDITION_KEY_CAR_EXTERIOR_REFIT . "$carId#$type";
    }

    //赛车强化Key
    public function getCarRefitKey(int $carId, int $type): string
    {
        return EventConditionData::EVENT_CONDITION_KEY_CAR_REFIT . "$carId#$type";
    }

    //增加value
    public function addEventConditionValue(string $key, int $value): int
    {
        /**
         * @var EventConditionModel $condition
         */
        $condition = ModelManager::getInstance()->getModel(ModelTypeDefine::EVENT_CONDITION);
        return $condition->addEventConditionValue($key, $value);
    }

    //获取单个数据--不存在的key,返回值为0
    public function getSingleEventConditionValue(string $key): int
    {
        /**
         * @var EventConditionModel $condition
         */
        $condition = ModelManager::getInstance()->getModel(ModelTypeDefine::EVENT_CONDITION);
        $result = $condition->getEventConditionValue([$key]);
        return $result[$key];
    }

    //获取多个数据--不存在的key,返回值为0
    public function getMultiEventConditionValue(array $keyList): array
    {
        /**
         * @var EventConditionModel $condition
         */
        $condition = ModelManager::getInstance()->getModel(ModelTypeDefine::EVENT_CONDITION);
        return $condition->getEventConditionValue($keyList);
    }

    //重置数据
    public function resetEventConditionValue(string $key)
    {
        /**
         * @var EventConditionModel $condition
         */
        $condition = ModelManager::getInstance()->getModel(ModelTypeDefine::EVENT_CONDITION);
        $condition->resetEventConditionValue($key);
    }

    //删除数据
    public function delEventConditionkey(string $key)
    {
        /**
         * @var EventConditionModel $condition
         */
        $condition = ModelManager::getInstance()->getModel(ModelTypeDefine::EVENT_CONDITION);
        $condition->delEventConditionKey($key);
    }
}