<?php
/**
 * 俱乐部商店
 */

namespace Game\Logic\Club;

use Framework\Log\LogMark;
use Framework\MVC\ModelManager;
use Framework\DB\Handler\PlayerDBHandler;
use Game\Constant\ClientErrorCode;
use Game\Constant\ConstTemplate\TemplateClubStore;
use Game\Constant\EventTypeDefine;
use Game\Constant\GameConstantDefine;
use Game\Constant\GameErrorCode;
use Game\Constant\ModelTypeDefine;
use Framework\Logic\TemplateHelp;
use Game\Constant\TemplateDefine;
use Game\Data\Club\ClubStoreData;
use Game\Logic\CarLogic;
use Game\Logic\ItemLogic;
use Game\Logic\MoneyLogic;
use Game\Logic\SeasonLogic;
use Game\Model\Club\ClubStoreModel;

trait ClubStoreLogic {
    use PlayerDBHandler;
    use TemplateHelp;
    use MoneyLogic;
    use CarLogic;
    use ItemLogic;
    use SeasonLogic;

    public int $playerID;

    // 购买道具
    public function buyClubStoreItem(int $id, int $num): bool {
        /**
         * @var ClubStoreModel $clubStoreModel
         */
        $clubStoreModel = ModelManager::getInstance()->getModel(ModelTypeDefine::CLUB_STORE);
        $cfg = $this->getTitle(TemplateDefine::TYPE_CLUB_STORE, $id);

        // 检测是否已经到购买上限
        if (!$clubStoreModel->checkBuyLimit($id, $num, $cfg)){
            return false;
        }

        if(is_null($cfg)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_SEARCH_ERROR,
                '[CLubModel] buy store item but search title error!',
                ['id' => $id]
            );
            $clubStoreModel->GCSendBuyStoreItem(ClientErrorCode::ERROR_CLUB_NOT_BUY);
            return false;
        }
        $this->setLogConsumeItemSource(GameConstantDefine::ITEM_CONSUME_SOURCE_BUY_CLUB_SHOP);
        $this->setLogAddItemSource(GameConstantDefine::ITEM_ADD_SOURCE_CLUB_SHOP);
        // 扣除货币
        if(!$this->subMoney($cfg[TemplateClubStore::CurrencyType], $cfg[TemplateClubStore::CurrencyNum])) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_UPDATE_ERROR,
                '[CLubModel] buy store item but sub money error!',
                ['id' => $id]
            );
            $clubStoreModel->GCSendBuyStoreItem(ClientErrorCode::ERROR_CLUB_STORE_BUY_MONEY);
            return false;
        }

        // 增加道具
        if(!$this->gainItem($cfg[TemplateClubStore::GoodsId], $num)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_UPDATE_ERROR,
                '[CLubModel] buy store item but add item error!',
                ['id' => $id]
            );
            $clubStoreModel->GCSendBuyStoreItem(ClientErrorCode::ERROR_EXEC_FAILED);
            return false;
        }

        // 增加购买记录
        if (!$clubStoreModel->addBuyStoreRecord($id, $num, $cfg)){
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_UPDATE_ERROR,
                '[CLubStoreLogic] buy store item but add item error!',
                ['id' => $id]
            );
            $clubStoreModel->GCSendBuyStoreItem(ClientErrorCode::ERROR_EXEC_FAILED);
            return false;
        }
        $clubStoreModel->GCSendBuyStoreItem(ClientErrorCode::CLIENT_SUCCESS);
        //商店购买道具
        $param = array(
            GameConstantDefine::EVENT_KEY_ITEM_ID => $cfg[TemplateClubStore::GoodsId],
            GameConstantDefine::EVENT_KEY_NUM => $num,
        );
        $this->triggerEvent(EventTypeDefine::EVENT_TYPE_TASK_SHOP_BUY_ITEM, $param);
        return true;
    }

    // 获取购买商城记录
    public function getStoreRecord():bool {
        /**
         * @var ClubStoreModel $clubStoreModel
         */
        $clubStoreModel = ModelManager::getInstance()->getModel(ModelTypeDefine::CLUB_STORE);

        $realData = [];
        $seasonId = $this->getSeasonId();
        $clubStore = $this->getTable(TemplateDefine::TYPE_CLUB_STORE);
        foreach($clubStore as $id=>$item) {
            if($item[TemplateClubStore::FlushedMatch] == 0 ||
                $item[TemplateClubStore::FlushedMatch] == $seasonId) {
                array_push($realData, [
                    ClubStoreData::ID => $id,
                ]);
            }
        }
        $res = $clubStoreModel->getStoreRecord($realData, $seasonId);
        $clubStoreModel->GCSendGetStoreRecord($res);
        return true;
    }
}