<?php

/**
 * 赛车统计数据
 */

namespace Game\Logic\Car;

use Framework\Log\LogMark;
use Framework\MVC\ModelManager;
use Game\Constant\ModelTypeDefine;
use Game\Data\Car\CarData;
use Game\Data\Car\CarStatisticsData;
use Game\Model\Car\CarModel;
use Game\Model\Car\CarStatisticModel;
use Game\Protobuf\CarStatisticsInfo;

trait CarStatisticsLogic
{
    //获取单个赛车统计信息
    public function getSingleCarCarStatisticsInfo(int $carUid, array &$protoArray)
    {
        /**
         * @var CarStatisticModel $carStatisticsModel
         */
        $carStatisticsModel = ModelManager::getInstance()->getModel(ModelTypeDefine::CAR_STATISTICS);
        $carStatisticsArray = $carStatisticsModel->getCarStatisticDataByCarUid($carUid);
        if (is_null($carStatisticsArray)) {
            $carStatisticsArray = $carStatisticsModel->initCarStatisticData($carUid);
        }
        $this->tidyCarCarStatisticsInfoToProtobuf($carStatisticsArray, $protoArray);
    }

    //获取全部赛车统计信息
    public function getAllCarCarStatisticsInfo(array &$protoArray)
    {
        /**
         * @var CarModel $carModel
         */
        $carModel = ModelManager::getInstance()->getModel(ModelTypeDefine::CAR);
        $allCars = $carModel->getPlayerCars();
        /**
         * @var CarData $car
         */
        foreach ($allCars as $car) {
            $this->getSingleCarCarStatisticsInfo($car->uid, $protoArray);
        }
    }

    //赛车统计信息转为protobuf
    private function tidyCarCarStatisticsInfoToProtobuf(array $data, array &$protoArray)
    {
        $carStatisticsInfo = new CarStatisticsInfo();
        $carStatisticsInfo->setCarId($data[CarData::CAR_ID]);
        $carStatisticsInfo->setMatchNum($data[CarStatisticsData::MATCH_NUM]);
        $carStatisticsInfo->setWinNum($data[CarStatisticsData::WIN_NUM]);
        $carStatisticsInfo->setMvpNum($data[CarStatisticsData::MVP_NUM]);
        $carStatisticsInfo->setIconNum($data[CarStatisticsData::ICON_NUM]);
        $carStatisticsInfo->setMaxWinNum($data[CarStatisticsData::MAX_WIN_NUM]);
        $carStatisticsInfo->setLastMvpFlag($data[CarStatisticsData::LAST_MVP_FLAG]);
        $protoArray[] = $carStatisticsInfo;
    }

    //比赛结束 更新赛车统计信息
    public function updateCarStatistics(array $data, int $carId)
    {
        /**
         * @var CarModel $carModel
         */
        $carModel = ModelManager::getInstance()->getModel(ModelTypeDefine::CAR);
        $car = $carModel->searchCarByCarID($carId);
        if (is_null($car)) {
            LogMark::getInstance()->markDebug(
                "[CarStatisticsLogic] car not found",
                array(
                    "CarId" => $carId
                )
            );
            return;
        }
        /**
         * @var CarStatisticModel $carStatisticsModel
         */
        $carStatisticsModel = ModelManager::getInstance()->getModel(ModelTypeDefine::CAR_STATISTICS);
        $carStatisticsArray = $carStatisticsModel->getCarStatisticDataByCarId($carId);
        if (is_null($carStatisticsArray)) {
            $carStatisticsArray = $carStatisticsModel->initCarStatisticData($car->uid);
        }
        $updateData = array(
            //比赛次数
            CarStatisticsData::MATCH_NUM => $carStatisticsArray[CarStatisticsData::MATCH_NUM] + 1
        );
        //检查是否胜利
        if (isset($data[CarStatisticsData::WIN_NUM])) {
            //胜利次数+1
            $updateData[CarStatisticsData::WIN_NUM] = $carStatisticsArray[CarStatisticsData::WIN_NUM] + 1;
            //本次胜利--检查是否连胜
            $updateData[CarStatisticsData::LAST_WIN_NUM] = $carStatisticsArray[CarStatisticsData::LAST_WIN_NUM] + 1;
            //最大连胜数
            if ($updateData[CarStatisticsData::LAST_WIN_NUM] >= $carStatisticsArray[CarStatisticsData::MAX_WIN_NUM]) {
                $updateData[CarStatisticsData::MAX_WIN_NUM] = $updateData[CarStatisticsData::LAST_WIN_NUM];
            }
        } else {
            //失败
            $updateData[CarStatisticsData::LAST_WIN_NUM] = CarStatisticsData::LAST_FAIL;
        }
        //检查MVp
        if (isset($data[CarStatisticsData::MVP_NUM])) {
            $updateData[CarStatisticsData::MVP_NUM] = $carStatisticsArray[CarStatisticsData::MVP_NUM] + 1;
            //记录本次获得mvp
            $updateData[CarStatisticsData::LAST_MVP_FLAG] = CarStatisticsData::LAST_GET_MVP;
        } else {
            //未获得MVP
            $updateData[CarStatisticsData::LAST_MVP_FLAG] = CarStatisticsData::LAST_LOSE_MVP;
        }
        //检查徽章
        if (isset($data[CarStatisticsData::ICON_NUM])) {
            $updateData[CarStatisticsData::ICON_NUM] = $carStatisticsArray[CarStatisticsData::ICON_NUM] + 1;
        }
        //保存
        $carStatisticsModel->saveCarStatisticData($updateData, $car->uid);
    }



}
