<?php

/**
 * 大乱斗结算
 */

namespace Game\Logic\Activity;

use Framework\MVC\ModelManager;
use Game\Constant\ConstTemplate\TemplateConst;
use Game\Constant\ConstTemplate\TemplateScuffleScore;
use Game\Constant\ModelTypeDefine;
use Game\Constant\TemplateDefine;
use Game\Data\Activity\ScuffleData;
use Game\Data\RaceResultData;
use Game\Logic\Friend\FriendLogic;
use Game\Model\Activity\ScuffleModel;

trait ScuffleSettlementLogic
{
    use FriendLogic;

    //比赛结算 计算获得骰子点数
    //公式 基础分+表现分
    //表现分= 团队胜利+30（170） 失败+40（171） MVP+10（172）
    public function countScuffleRollPoint(bool $teamIsWin, bool $isMvp): int
    {
        $baseScore = $this->getTerm(
            TemplateDefine::TYPE_CONST,
            TemplateConst::Const_Scuffle_Roll_Point_Settlement_Base_Score,
            TemplateConst::ConstNum);
        if ($teamIsWin) {
            $baseScore += $this->getTerm(
                TemplateDefine::TYPE_CONST,
                TemplateConst::Const_Scuffle_Roll_Point_Settlement_Win_Score,
                TemplateConst::ConstNum);
        } else {
            $baseScore += $this->getTerm(
                TemplateDefine::TYPE_CONST,
                TemplateConst::Const_Scuffle_Roll_Point_Settlement_Fail_Score,
                TemplateConst::ConstNum);
        }
        if ($isMvp) {
            $baseScore += $this->getTerm(
                TemplateDefine::TYPE_CONST,
                TemplateConst::Const_Scuffle_Roll_Point_Settlement_MVP_Score,
                TemplateConst::ConstNum);
        }
        return $baseScore;
    }

    //比赛结算 获得乱斗积分 RandomIntegral表
    public function countScuffleScore(RaceResultData $raceResult, int $playerId, bool $teamIsWin): array
    {
        $config = $this->getTable(TemplateDefine::TYPE_SCUFFLE_SCORE);
        $score = $config[TemplateScuffleScore::SCUFFLE_SCORE_SETTLEMENT_BASE][TemplateScuffleScore::Number];
        $scoreArray = array(
            TemplateScuffleScore::SCUFFLE_SCORE_SETTLEMENT_BASE
        );
        //是否首次使用车
        $scuffleData = $this->getScuffleData();
        $useCar = json_decode($scuffleData->scuffleUseCar, true);
        if (!in_array($raceResult->_carId, $useCar)) {
            $score += $config[TemplateScuffleScore::SCUFFLE_SCORE_SETTLEMENT_FIRST_USE_CAR][TemplateScuffleScore::Number];
            $scoreArray[] = TemplateScuffleScore::SCUFFLE_SCORE_SETTLEMENT_FIRST_USE_CAR;
            if ($teamIsWin) {
                //首次使用并胜利
                $score += $config[TemplateScuffleScore::SCUFFLE_SCORE_SETTLEMENT_FIRST_USE_CAR_WIN][TemplateScuffleScore::Number];
                $scoreArray[] = TemplateScuffleScore::SCUFFLE_SCORE_SETTLEMENT_FIRST_USE_CAR_WIN;
            }
        }
        //与好友组队
        $withFriend = false;
        foreach ($this->myTeamPlayerIds as $pId) {
            if (!$this->checkIsAIPlayer($pId) && $pId != $playerId && $this->checkTargetPlayerIsMyFriend($pId)) {
                $withFriend = true;
            }
        }
        if ($withFriend) {
            $score += $config[TemplateScuffleScore::SCUFFLE_SCORE_SETTLEMENT_PLAY_WITH_FRIEND][TemplateScuffleScore::Number];
            $scoreArray[] = TemplateScuffleScore::SCUFFLE_SCORE_SETTLEMENT_PLAY_WITH_FRIEND;
        }
        //每日首胜
        if ($scuffleData->scuffleDailyWin == 0 && $teamIsWin) {
            $score += $config[TemplateScuffleScore::SCUFFLE_SCORE_SETTLEMENT_DAILY_FIRST_WIN][TemplateScuffleScore::Number];
            $scoreArray[] = TemplateScuffleScore::SCUFFLE_SCORE_SETTLEMENT_DAILY_FIRST_WIN;
        }
        //每局冲线
        if ($raceResult->_costTime > 0) {
            $score += $config[TemplateScuffleScore::SCUFFLE_SCORE_SETTLEMENT_RACE_WIN][TemplateScuffleScore::Number];
            $scoreArray[] = TemplateScuffleScore::SCUFFLE_SCORE_SETTLEMENT_RACE_WIN;
        }
        //MVP
        if ($raceResult->_mvpIcon) {
            $score += $config[TemplateScuffleScore::SCUFFLE_SCORE_SETTLEMENT_MVP][TemplateScuffleScore::Number];
            $scoreArray[] = TemplateScuffleScore::SCUFFLE_SCORE_SETTLEMENT_MVP;
        }
        //精彩表现 金牌竞速、金牌干扰、金牌辅助
        if ($raceResult->_raceIcon) {
            $score += $config[TemplateScuffleScore::SCUFFLE_SCORE_SETTLEMENT_RACE_ICON][TemplateScuffleScore::Number];
            $scoreArray[] = TemplateScuffleScore::SCUFFLE_SCORE_SETTLEMENT_RACE_ICON;
        }
        if ($raceResult->_jamIcon) {
            $score += $config[TemplateScuffleScore::SCUFFLE_SCORE_SETTLEMENT_JAM_ICON][TemplateScuffleScore::Number];
            $scoreArray[] = TemplateScuffleScore::SCUFFLE_SCORE_SETTLEMENT_JAM_ICON;
        }
        if ($raceResult->_helpIcon) {
            $score += $config[TemplateScuffleScore::SCUFFLE_SCORE_SETTLEMENT_HELP_ICON][TemplateScuffleScore::Number];
            $scoreArray[] = TemplateScuffleScore::SCUFFLE_SCORE_SETTLEMENT_HELP_ICON;
        }
        //TODO:消极比赛
        return [$score, $scoreArray];
    }

    //比赛结算 加骰子点数和乱斗积分
    public function addScuffleScore(int $addPoint, int $addScore, int $carId, bool $teamIsWin)
    {
        /**
         * @var ScuffleModel $scuffleModel
         */
        $scuffleModel = ModelManager::getInstance()->getModel(ModelTypeDefine::SCUFFLE);
        $scuffleModel->addScuffleData($addPoint, $addScore, $carId, $teamIsWin);
    }

    public function getScuffleData(): ScuffleData
    {
        /**
         * @var ScuffleModel $scuffleModel
         */
        $scuffleModel = ModelManager::getInstance()->getModel(ModelTypeDefine::SCUFFLE);
        return $scuffleModel->getScuffleData();
    }
}
