<?php

/**
 * 活动信息
 */

namespace Game\Logic\Activity;

use Game\Constant\ActivityDefine;
use Game\Constant\GameConstantDefine;
use Game\Logic\CommonConstLogic;
use Game\Protobuf\ActivityInfo;

trait ActivityLogic
{
    use CommonConstLogic;

    //获取全部的活动信息
    public function getAllActivityInfo(): array
    {
        $activityInfo = array();
        $commonConst = $this->getCommonConstData();
        $activityInfo[] = $this->getMapChallengeInfo($commonConst);
        $activityInfo[] = $this->getScuffleInfo($commonConst);
        return $activityInfo;
    }

    //获取地图挑战赛活动信息
    private function getMapChallengeInfo(array $commonConst): ActivityInfo
    {
        $info = new ActivityInfo();
        $info->setActivity(ActivityDefine::ACTIVITY_NAME_MAP_CHALLENGE);
        $info->setActivityId($commonConst[GameConstantDefine::COMMON_KEY_ACTIVITY_MAP_CHALLENGE]);
        $info->setStatus($commonConst[GameConstantDefine::COMMON_KEY_ACTIVITY_MAP_CHALLENGE_STATUS]);
        $info->setStartTime($commonConst[GameConstantDefine::COMMON_KEY_ACTIVITY_MAP_CHALLENGE_START_TIME]);
        $info->setEndTime($commonConst[GameConstantDefine::COMMON_KEY_ACTIVITY_MAP_CHALLENGE_END_TIME]);
        return $info;
    }

    //获取大乱斗活动信息
    private function getScuffleInfo(array $commonConst): ActivityInfo
    {
        $info = new ActivityInfo();
        $info->setActivity(ActivityDefine::ACTIVITY_NAME_SCUFFLE);
        $info->setActivityId(0);
        $info->setStatus($commonConst[GameConstantDefine::COMMON_KEY_ACTIVITY_SCUFFLE_STATUS]);
        $info->setStartTime($commonConst[GameConstantDefine::COMMON_KEY_ACTIVITY_SCUFFLE_START_TIME]);
        $info->setEndTime($commonConst[GameConstantDefine::COMMON_KEY_ACTIVITY_SCUFFLE_END_TIME]);
        return $info;
    }
}
