<?php

/**
 * 活跃度
 */

namespace Game\Logic;

use Framework\Lib\Utils;
use Framework\MVC\ModelManager;
use Game\Constant\ConstTemplate\TemplateConst;
use Game\Constant\ModelTypeDefine;
use Game\Constant\TemplateDefine;
use Game\Model\Task\ActiveModel;

trait ActiveLogic
{
    use MailLogic;

    //检查活跃度可领取奖励
    public function getActiveLvData(): array
    {
        /**
         * @var ActiveModel $activeModel
         */
        $activeModel = ModelManager::getInstance()->getModel(ModelTypeDefine::TASK_ACTIVE);
        $activeData = $activeModel->getActiveData();
        return array(
            $activeData->activeId,                                      //当前等级
            $activeModel->getActiveLv($activeData->activePoint),        //可领取等级
            $activeModel->getActiveMaxLv()                              //最高等级
        );
    }

    //增加活跃度
    public function addActivePoint(int $num)
    {
        /**
         * @var ActiveModel $activeModel
         */
        $activeModel = ModelManager::getInstance()->getModel(ModelTypeDefine::TASK_ACTIVE);
        $activeModel->addActivePoint($num);
    }

    //重置活跃度
    public function initActiveInfo()
    {
        /**
         * @var ActiveModel $activeModel
         */
        $activeModel = ModelManager::getInstance()->getModel(ModelTypeDefine::TASK_ACTIVE);
        $activeModel->reset();
    }

    //未领取奖励邮件
    public function sendActiveRewardMail()
    {
        //检查可领取奖励
        $reward = $this->getActiveReward();
        if (!empty($reward)) {
            //发送邮件
            $mailTplId = $this->getTerm(TemplateDefine::TYPE_CONST,
                                        TemplateConst::Const_Task_Daily_Week_Active_Mail_id,
                                        TemplateConst::ConstNum);
            $this->createPlayerMail($mailTplId, Utils::getServerTimestamp(), $reward);
        }
    }

    //获取可领取的活跃度奖励
    private function getActiveReward(): array
    {
        $reward = array();
        //检查可领取奖励
        [$nowLv, $canLv, $maxLv] = $this->getActiveLvData();
        if ($nowLv >= $maxLv) {
            return $reward;
        }
        if ($nowLv >= $canLv) {
            return $reward;
        }
        /**
         * @var ActiveModel $activeModel
         */
        $activeModel = ModelManager::getInstance()->getModel(ModelTypeDefine::TASK_ACTIVE);
        return $activeModel->getActiveReward($nowLv, $canLv);
    }
}