<?php
/**
 *
 * @date 2022-3-12
 * @author JZW
 **/


namespace Game\Logic;


use Framework\Lib\Utils;
use Framework\Logic\TemplateHelp;
use Game\Constant\GameConstantDefine;
use Game\Constant\TemplateDefine;

trait AIRoleLogic
{
    use CarLogic;
    use TemplateHelp;

    //自动创建Role
    public function cAIRole(int $playerId): bool
    {
        $roleData = array(
            "Gender" => 0,
            "NickName" => $this->randomName(),
            "Head" => 1,
            "Hair" => 2,
            "Feature" => 3,
            "Jacket" => 4,
            "Pants" => 5,
            "Shoes" => 6,
        );

        $this->cRole($playerId, GameConstantDefine::CreateRoleStepSetPeople, $roleData);

        $carId = '1001';
        $carUid = $this->cCar($carId);

        $data = [
            "Step" => 2,
            "DefaultCar" => $carUid,
            "FinishRole" => true,
        ];
        $this->uRoleData($data);

        return true;
    }

    public function randomName(): string
    {
        $names = $this->getTable(TemplateDefine::TYPE_RANDOM_ID);
        $first = random_int(0, count($names[1]));
        $end = random_int(0, count($names[2]));
        $nickname = $names[1][$first].$names[2][$end];
        $this->checkRoleName($nickname);
        return $nickname;
    }

    public function cRoleId()
    {
        for($i=1; $i<262143; $i++)
        {
            $s = Utils::uniqueRoleId(1, 1023, $i);
            file_put_contents("/tmp/roldid.txt", $s."\n", 8);
        }
    }
}