<?php


namespace Game;


use Framework\Common\ConfigManager;
use Framework\Define\ErrorDefine;
use Framework\Log\LogMark;
use Framework\MVC\ModelManager;
use Framework\Network\SendMessage;
use Game\Config\GameConfig;
use Game\Constant\DBTableDefine;
use Game\Constant\ModelTypeDefine;
use Game\Constant\PacketDefineI;
use Game\Operation\PlatformManager;
use Library\Common\Singletons;
use Library\MemoryCache;
use Throwable;

class GameLive
{
    use Singletons;

    public int $playerId;

    /**
     * 初始化游戏区
     * @param $zone
     */
    public function InitZone($zone)
    {
        $root = dirname(__FILE__);
        $root = dirname($root);
        $zoneFile = $root . "/Zone/" . $zone . ".php";
        require_once $zoneFile;
        $zone = "Zone\\" . $zone;
        $config = new $zone();
        $config->InitConfig();
        GameConfig::getInstance()->InitConfig($config);
    }

    /**
     * 初始化日志
     * @param $logPath
     */
    public function InitLog($logPath)
    {
        LogMark::getInstance()->init($logPath);
    }

    /**
     * 初始化异常配置
     */
    public function InitException()
    {
        set_exception_handler(function (Throwable $exception) {
            $this->catchException($exception);
        });


        set_error_handler(function (int $number, string $message, string $error_file, int $error_line) {
            $log = "catch error";
            LogMark::getInstance()->markCritical(
                ErrorDefine::EXCEPTION_ERROR,
                $log,
                array("errorInfo" => $message, "code" => $number, "file" => $error_file, "line" => $error_line)
            );
        });
        
        register_shutdown_function(function () {
            // todo 程序结束后，检查是否有报错情况
        });
    }

    /**
     * 初始化常量配置
     */
    public function InitDefineConfig()
    {
        ConfigManager::getInstance()->setPacketDefine(new PacketDefineI());
        ConfigManager::getInstance()->setModelDefine(new ModelTypeDefine());
        ConfigManager::getInstance()->setRedisConfig(new DBTableDefine());
        ConfigManager::getInstance()->setCheckRequest(new CheckRequest());
        ConfigManager::getInstance()->loadConfig();
    }

    /**
     * 初始化主角 id
     * @param $playerId
     */
    public function InitProtagonistPlayerId($playerId)
    {
        LogMark::getInstance()->setPlayerId($playerId);
        ModelManager::getInstance()->setPlayerId($playerId);
        $this->playerId = $playerId;
    }

    /**
     * 游戏结束后的清理
     */
    public function GameOver()
    {
        SendMessage::getInstance()->respondClient();
        ConfigManager::getInstance()->closeConnect();
        PlatformManager::getInstance()->close();

    }


    public function catchException(Throwable $exception)
    {
        $log = "catch exception";
        LogMark::getInstance()->markCritical(
            ErrorDefine::EXCEPTION_ERROR,
            $log,
            array("exception" => $exception->getMessage(), "code" => $exception->getCode(),
                "file" => $exception->getFile(), "line" => $exception->getLine(),
                "trace" => $exception->getTraceAsString())
        );
        //出现异常 释放内存锁
        MemoryCache::getInstance()->releaseLock();
    }


}