<?php

/**
 * 战令
 */

namespace Game\Data;

use Framework\DB\Handler\PlayerDBHandler;
use Framework\Logic\TemplateHelp;
use Game\Constant\ConstTemplate\TemplateConst;
use Game\Constant\DBTableDefine;
use Game\Constant\ModelTypeDefine;
use Game\Constant\TemplateDefine;

class WarTokenData
{
    use PlayerDBHandler;
    use TemplateHelp;

    public int $playerId;

    public const PrimaryIds = "PrimaryIds";   //普通奖励领取进度
    public const ExpertIds = "ExpertIds";     //初级/高级奖励领取进度
    public const WarTokenExp = "WarTokenExp";   //战令经验
    public const ExpertFlag = "ExpertFlag";     //高阶开通标志    0普通 1初级 2高级
    public const WeekExp = "WeekExp";       //每日任务对应周经验
    public const OverFlowExp = "OverFlowExp";   //溢出经验
    public const OverMaxFlag = "OverMaxFlag"; //达到上限标志

    public const DB_KEY_MAP = array(
        self::PrimaryIds => "primaryIds",
        self::ExpertIds => "expertIds",
        self::WarTokenExp => "warTokenExp",
        self::ExpertFlag => "expertFlag",
        self::WeekExp => "weekExp",
        self::OverFlowExp => "overFlowExp",
        self::OverMaxFlag => "overMaxFlag",
    );

    public string $primaryIds = "[]";
    public string $expertIds = "[]";
    public int $warTokenExp = 0;
    public int $expertFlag;
    public int $weekExp;
    public int $overFlowExp;
    public int $overMaxFlag;

    public const EXPERT_FLAG_DEFAULT = 0;   // 普通
    public const EXPERT_FLAG_PRIMARY = 1;   // 初级
    public const EXPERT_FLAG_EXPERT = 2;    // 高级

    public const OVER_MAX_FLAG_DEFAULT = 0; //默认经验未超上限
    public const OVER_MAX_FLAG_OPEN = 1;    //超上限

    public const ZL_DEMAND = 1;   // 索要
    public const ZL_GIVE = 2;     // 赠送

    public function __construct($playerId)
    {
        $this->playerId = $playerId;
    }

    public function initWarToken()
    {
        $this->primaryIds = "[]";
        $this->expertIds = "[]";
        $this->warTokenExp = 0;
        $this->expertFlag = self::EXPERT_FLAG_DEFAULT;
        $this->weekExp = 0;
        $this->overFlowExp = 0;
        $this->overMaxFlag = self::OVER_MAX_FLAG_DEFAULT;
    }

    public function setExpertFlag(int $flag)
    {
        $this->expertFlag = $flag;
    }

    public function createDB()
    {
        $data = array();
        foreach (self::DB_KEY_MAP as $k => $v) {
            $data[$k] = $this->$v;
        }
        return $this->createTitle(
            DBTableDefine::TABLE_WAR_TOKEN,
            $this->playerId,
            0,
            $data
        );
    }

    public function searchDB(): bool
    {
        $result = array();
        if (!$this->searchTitle(
            DBTableDefine::TABLE_WAR_TOKEN,
            $this->playerId,
            0,
            $result)
        ) {
            return false;
        }
        if (empty($result)) {
            return false;
        }
        foreach ($result as $k => $v) {
            $this->setDBData($k, $v);
        }
        return true;
    }

    public function updateDB(): bool
    {
        $data = array();
        foreach (self::DB_KEY_MAP as $k => $v) {
            if (is_numeric($this->$v)) {
                $data[$k] = (int)$this->$v;
            } else {
                $data[$k] = $this->$v;
            }
        }
        return $this->updateTitle(
            DBTableDefine::TABLE_WAR_TOKEN,
            $this->playerId,
            0,
            $data
        );
    }

    private function setDBData($key, $value)
    {
        if (!array_key_exists($key, self::DB_KEY_MAP)) {
            return;
        }
        $property = self::DB_KEY_MAP[$key];
        if ($key == self::ExpertIds || $key == self::PrimaryIds) {
            $this->$property = $value;
        } else {
            $this->$property = (int)$value;
        }
    }
}
