<?php

/**
 * 任务兑换商城
 */

namespace Game\Data\Shop;

use Framework\DB\Handler\PlayerDBHandler;
use Game\Constant\DBTableDefine;

class ShopTaskExchangeData
{
    use PlayerDBHandler;

    public int $playerId;
    public const RefreshDate = "RefreshDate";   //刷新时间,刷新每周限购用

    public function __construct(int $playerId)
    {
        $this->playerId = $playerId;
    }

    public function updateDB($title, array $data): bool
    {
        return $this->updateTitle(
            DBTableDefine::TABLE_TASK_EXCHANGE_SHOP,
            $this->playerId,
            $title,
            $data,
        );
    }

    public function searchDB($title): array
    {
        $result = array();
        if (false == $this->searchTitle(
                DBTableDefine::TABLE_TASK_EXCHANGE_SHOP,
                $this->playerId,
                $title,
                $result
            )) {
            return [];
        }
        return $result;
    }

    //获取刷新时间
    public function getFreshDate($title): int
    {
        $result = array();
        if (!$this->searchTitle(
            DBTableDefine::TABLE_TASK_EXCHANGE_SHOP,
            $this->playerId,
            $title,
            $result
        ))
        {
            return 0;
        }
        return $result[self::RefreshDate];
    }

    //删除商城道具id
    public function delItemId($title, array $ids): bool
    {
        $ret = 0;
        return $this->delTermMulti(
            $ret,
            DBTableDefine::TABLE_TASK_EXCHANGE_SHOP,
            $this->playerId,
            $title,
            $ids
        );
    }
}
