<?php

/**
 * 赛季商城
 */

namespace Game\Data\Shop;

use Framework\DB\Handler\PlayerDBHandler;
use Game\Constant\DBTableDefine;

class ShopSeasonData
{
    use PlayerDBHandler;

    public int $playerId;

    public const RefreshDate = "RefreshDate";   //刷新时间,刷新每周限购用
    public const SeasonId = "SeasonId";         //当前商城数据所属赛季id

    public function __construct(int $playerId)
    {
        $this->playerId = $playerId;
    }

    public function updateDB(array $data): bool
    {
        return $this->updateTitle(
            DBTableDefine::TABLE_SHOP_SEASON,
            $this->playerId,
            0,
            $data,
        );
    }

    public function searchDB(): array
    {
        $result = array();
        if (false == $this->searchTitle(
                DBTableDefine::TABLE_SHOP_SEASON,
                $this->playerId,
                0,
                $result
            )) {
            return [];
        }
        return $result;
    }

    //获取刷新时间
    public function getFreshDate(): int
    {
        $result = array();
        if (!$this->searchTitle(
            DBTableDefine::TABLE_SHOP_SEASON,
            $this->playerId,
            0,
            $result
        ))
        {
            return 0;
        }
        return $result[self::RefreshDate];
    }

    //删除商城道具id
    public function delItemId(array $ids): bool
    {
        $ret = 0;
        return $this->delTermMulti(
            $ret,
            DBTableDefine::TABLE_SHOP_SEASON,
            $this->playerId,
            0,
            $ids
        );
    }
}
