<?php

/**
 * 道具商城
 */

namespace Game\Data\Shop;

use Framework\DB\Handler\PlayerDBHandler;
use Game\Constant\DBTableDefine;

class ShopItemData
{
    use PlayerDBHandler;

    public int $playerId;

    public const RefreshDate = "RefreshDate";   //刷新时间,刷新每周限购用

    public const DB_KEY_MAP = array(
        self::RefreshDate => "refreshDate",
    );

    public function __construct(int $playerId)
    {
        $this->playerId = $playerId;
    }

    public function updateDB(array $data): bool
    {
        return $this->updateTitle(
            DBTableDefine::TABLE_SHOP_ITEM,
            $this->playerId,
            0,
            $data,
        );
    }

    public function searchDB(): array
    {
        $result = array();
        if (!$this->searchTitle(
                DBTableDefine::TABLE_SHOP_ITEM,
                $this->playerId,
                0,
                $result
            )) {
            return [];
        }
        return $result;
    }

    //获取刷新时间
    public function getFreshDate(): int
    {
        $result = array();
        if (!$this->searchTitle(
            DBTableDefine::TABLE_SHOP_ITEM,
            $this->playerId,
            0,
            $result
        ))
        {
            return 0;
        }
        return $result[self::RefreshDate];
    }

    //删除商城道具id
    public function delItemId(array $ids): bool
    {
        $ret = 0;
        return $this->delTermMulti(
            $ret,
            DBTableDefine::TABLE_SHOP_ITEM,
            $this->playerId,
            0,
            $ids
        );
    }
}
