<?php

/**
 * 抽奖商城
 */

namespace Game\Data\Shop;

use Framework\DB\Handler\PlayerDBHandler;
use Game\Constant\DBTableDefine;

class ShopBlindBoxData
{
    use PlayerDBHandler;

    public int $playerId;

    public const DRAW_GROUP_NUM = "drawGroupNum";  //每组抽中次数,[组Id,抽中次数]
    public const DRAW_IGNORE_ITEM_BOX_ID = "drawIgnoreItemBoxId";   //忽略ItemBox表Id(组中唯一的道具都已拥有,忽略此组)

    public function __construct(int $playerId)
    {
        $this->playerId = $playerId;
    }

    public function updateDB(array $data): bool
    {
        return $this->updateTitle(
            DBTableDefine::TABLE_SHOP_BLIND_BOX,
            $this->playerId,
            0,
            $data,
        );
    }

    public function searchDB(): array
    {
        $result = array();
        if (false == $this->searchTitle(
                DBTableDefine::TABLE_SHOP_BLIND_BOX,
                $this->playerId,
                0,
                $result
            )) {
            return [];
        }
        return $result;
    }
}
