<?php

/**
 * 赛季统计数据
 */

namespace Game\Data;

use Framework\DB\Handler\PlayerDBPipe;
use Framework\Log\LogMark;
use Framework\DB\Handler\PlayerDBHandler;
use Game\Constant\DBTableDefine;
use Game\Constant\GameErrorCode;

class SeasonStatisticsData
{
    use PlayerDBHandler;

    public int $playerId;

    public int $title;
    public const TITLE_RANKING = 1;     //排位赛统计
    public const TITLE_PRACTICE = 2;    //练习赛统计

    //当前赛季
    public const NS_NUM = "NSNum";  //比赛次数
    public const NS_RACE_POSITION_NUM = "NSRacePositionNum";    //竞速位次数
    public const NS_JAM_POSITION_NUM = "NSJamPositionNum";      //干扰位次数
    public const NS_HELP_POSITION_NUM = "NSHelpPositionNum";    //辅助位次数
    public const NS_WIN_NUM = "NSWinNum";   //获胜次数(个人前三,组队团队胜利)
    public const NS_MVP_NUM = "NSMvpNum";   //MVP次数
    public const NS_ICON_RACE_NUM = "NSIconRaceNum";    //竞速徽章次数
    public const NS_ICON_JAM_NUM = "NSIconJamNum";      //干扰徽章次数
    public const NS_ICON_HELP_NUM = "NSIconHelpNum";    //辅助徽章次数
    public const NS_NO1_NUM = "NSNo1Num";   //第一名次数
    public const NS_NO2_NUM = "NSNo2Num";   //第2名次数
    public const NS_NO3_NUM = "NSNo3Num";   //第3名次数

    //全部赛季
    public const AS_NUM = "ASNum";  //比赛次数
    public const AS_RACE_POSITION_NUM = "ASRacePositionNum";    //竞速位次数
    public const AS_JAM_POSITION_NUM = "ASJamPositionNum";      //干扰位次数
    public const AS_HELP_POSITION_NUM = "ASHelpPositionNum";    //辅助位次数
    public const AS_WIN_NUM = "ASWinNum";   //获胜次数(个人前三,组队团队胜利)
    public const AS_MVP_NUM = "ASMvpNum";   //MVP次数
    public const AS_ICON_RACE_NUM = "ASIconRaceNum";    //竞速徽章次数
    public const AS_ICON_JAM_NUM = "ASIconJamNum";      //干扰徽章次数
    public const AS_ICON_HELP_NUM = "ASIconHelpNum";    //辅助徽章次数
    public const AS_NO1_NUM = "ASNo1Num";   //第一名次数
    public const AS_NO2_NUM = "ASNo2Num";   //第2名次数
    public const AS_NO3_NUM = "ASNo3Num";   //第3名次数

    public const DB_KEY_MAP = array(
        self::NS_NUM,
        self::NS_RACE_POSITION_NUM,
        self::NS_JAM_POSITION_NUM,
        self::NS_HELP_POSITION_NUM,
        self::NS_WIN_NUM,
        self::NS_MVP_NUM,
        self::NS_ICON_RACE_NUM,
        self::NS_ICON_JAM_NUM,
        self::NS_ICON_HELP_NUM,
        self::NS_NO1_NUM,
        self::NS_NO2_NUM,
        self::NS_NO3_NUM,
        self::AS_NUM,
        self::AS_RACE_POSITION_NUM,
        self::AS_JAM_POSITION_NUM,
        self::AS_HELP_POSITION_NUM,
        self::AS_WIN_NUM,
        self::AS_MVP_NUM,
        self::AS_ICON_RACE_NUM,
        self::AS_ICON_JAM_NUM,
        self::AS_ICON_HELP_NUM,
        self::AS_NO1_NUM,
        self::AS_NO2_NUM,
        self::AS_NO3_NUM,
    );

    //当前赛季key对应全部赛季含义一致的key
    public const NOW_SEASON_TO_ALL_SEASON_KEY = array(
        self::NS_NUM => self::AS_NUM,
        self::NS_RACE_POSITION_NUM => self::AS_RACE_POSITION_NUM,
        self::NS_JAM_POSITION_NUM => self::AS_JAM_POSITION_NUM,
        self::NS_HELP_POSITION_NUM => self::AS_HELP_POSITION_NUM,
        self::NS_WIN_NUM => self::AS_WIN_NUM,
        self::NS_MVP_NUM => self::AS_MVP_NUM,
        self::NS_ICON_RACE_NUM => self::AS_ICON_RACE_NUM,
        self::NS_ICON_JAM_NUM => self::AS_ICON_JAM_NUM,
        self::NS_ICON_HELP_NUM => self::AS_ICON_HELP_NUM,
        self::NS_NO1_NUM => self::AS_NO1_NUM,
        self::NS_NO2_NUM => self::AS_NO2_NUM,
        self::NS_NO3_NUM => self::AS_NO3_NUM,
    );

    //当前赛季的key 重置赛季时用
    public const NOW_SEASON_KEY = array(
        self::NS_NUM,
        self::NS_RACE_POSITION_NUM,
        self::NS_JAM_POSITION_NUM,
        self::NS_HELP_POSITION_NUM,
        self::NS_WIN_NUM,
        self::NS_MVP_NUM,
        self::NS_ICON_RACE_NUM,
        self::NS_ICON_JAM_NUM,
        self::NS_ICON_HELP_NUM,
        self::NS_NO1_NUM,
        self::NS_NO2_NUM,
        self::NS_NO3_NUM,
    );

    public function __construct(int $playerId)
    {
        $this->playerId = $playerId;
    }

    public function setTitle(int $title)
    {
        $this->title = $title;
    }

    public function createDB(array $data): bool
    {
        if(!$this->createTitle(
            DBTableDefine::TABLE_SEASON_STATISTICS,
                    $this->playerId,
                    $this->title,
                    $data
        )) {
            LogMark::getInstance()->markWarn(
                GameErrorCode::DATA_CREATE_ERROR,
              '[SeasonStatisticsData] create data error!',
                        $data
            );
            return false;
        }
        return true;
    }

    public function registerDB(array $data): bool
    {
        return PlayerDBPipe::getInstance()->createTitle(
            DBTableDefine::TABLE_SEASON_STATISTICS,
            $this->playerId,
            $this->title,
            $data
        );
    }

    public function saveDB(array $data): bool
    {
        return $this->updateTitle(
            DBTableDefine::TABLE_SEASON_STATISTICS,
            $this->playerId,
            $this->title,
            $data
        );
    }

    public function getDataFromDB(): array
    {
        $result = array();
        if (!$this->searchTitle(
            DBTableDefine::TABLE_SEASON_STATISTICS,
            $this->playerId,
            $this->title,
            $result
        )) {
            return array();
        }
        return $this->formatData($result);
    }

    private function formatData($result): array
    {
        $data = array();
        foreach ($result as $key => $value) {
            $data[$key] = intval($value);
        }
        return $data;
    }
}
