<?php

/**
 * 大乱斗房间
 */

namespace Game\Data\Room;

use Framework\DB\Handler\PlayerDBHandler;
use Framework\Lib\Utils;
use Framework\Log\LogMark;
use Game\Constant\DBTableDefine;
use Game\Constant\GameErrorCode;

class ScuffleRoomData
{
    use PlayerDBHandler;

    public const ROOM_ID = "RoomId";    //==MatchUid
    public const MAP_ID = "MapId";
    public const CREATE_TIME = "CreateTime";    //创建时间
    public const PUBLIC_CAR_POOL_1 = "PublicCarPool1";       //公共车池  1队
    public const PUBLIC_CAR_POOL_2 = "PublicCarPool2";       //公共车池  2队
    public const HAVE_CAR_POOL_1 = "HaveCarPool1";      //已随机到的车id  1队
    public const HAVE_CAR_POOL_2 = "HaveCarPool2";      //已随机到的车id  2队

    public int $roomId;

    public function __construct(int $roomId)
    {
        $this->roomId = $roomId;
    }

    //CarPool key
    public const CAR_ID = "CarId";
    public const POOL_CD = "PoolCd";
    public const INDEX = "Index";   //位置索引
    //player申请记录key
    public const APPLY_KEY = "Apply";
    public const APPLY_STATUS = "ApplyStatus";  //申请状态
    public const APPLY_TIME = "ApplyTime";      //申请时间

    public const APPLY_STATUS_WAIT = 0;      //申请结果-等待
    public const APPLY_STATUS_OVER = 1;      //申请结果-完成

    public const APPLY_RESULT_STATUS_WAIT = 0;      //申请结果-等待
    public const APPLY_RESULT_STATUS_PASS = 1;      //申请结果-同意
    public const APPLY_RESULT_STATUS_REFUSE = 2;    //申请结果-拒绝

    //初始公共车池数据
    public static function initPublicCarPool(): array
    {
        $pool = array(
            self::INDEX => 1
        );
        $tmp = array(
            self::CAR_ID => 0,
            self::POOL_CD => 0
        );
        for ($i = 1; $i <= 6; $i++) {
            $pool[$i] = $tmp;
        }
        return $pool;
    }

    public function createRoom(array $data): bool
    {
        return $this->updateTitle(
            DBTableDefine::TABLE_ROOM_SCUFFLE,
            0,
            $this->roomId,
            $data
        );
    }

    public function createRoomTime(): bool
    {
        return $this->addRank(
            DBTableDefine::TABLE_ROOM_SCUFFLE_TIME,
            0,
            $this->roomId,
            Utils::getServerTimestamp(),
        );
    }

    public function searchScuffleRoom(): array
    {
        if (!$this->searchTitle(
            DBTableDefine::TABLE_ROOM_SCUFFLE,
            0,
            $this->roomId,
            $result
        )) {
            return array();
        }
        return $result;
    }

    public function saveRoom(array $data): bool
    {
        return $this->updateTitle(
            DBTableDefine::TABLE_ROOM_SCUFFLE,
            0,
            $this->roomId,
            $data
        );
    }

    public function delRoom(): bool
    {
        if(!$this->deleteQueueTitle(
            DBTableDefine::TABLE_ROOM_SCUFFLE,
            $this->roomId)
        ){
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_DELETE_ERROR,
                '[ScuffleRoomData] delete scuffle error!',
                array(
                    "roomId" => $this->roomId
                )
            );
            return false;
        }
        return true;
    }

    public function delRoomTime(): bool
    {
        if (!$this->delRank(
            DBTableDefine::TABLE_ROOM_SCUFFLE_TIME,
            0,
            $this->roomId)
        ){
            LogMark::getInstance()->markDebug(
                '[ScuffleRoomData] del room time error!',
                array(
                    "roomId" => $this->roomId
                )
            );
            return false;
        }
        return true;
    }

    //查询过期的大乱斗房间
    public function getOverTimeScuffleRoom(): array
    {
        $endTime = Utils::getServerTimestamp() - 180;
        if (false === $this->searchRank(
                DBTableDefine::TABLE_ROOM_SCUFFLE_TIME,
                0,
                0,
                $endTime,
                $ret
            )){
            LogMark::getInstance()->markError(
                GameErrorCode::ROOM_SEARCH_OFFLINE_ERROR,
                "[ScuffleRoomData] search over time scuffle room error",
                array(
                    "endTime" => $endTime
                )
            );
            return [];
        }
        return $ret;
    }
}
