<?php
/**
 * 角色可以修改的字段数据
 * @date 2022-3-21
 * @author JZW
 */
namespace Game\Data;

use Framework\DB\Handler\PlayerDBHandler;
use Game\Constant\DBTableDefine;
use Game\Constant\GameConstantDefine;

class RoleExtData {
    use PlayerDBHandler;

    public const DB_LOCATION = "Location";   //地区标识
    public const DB_Status = "Status";  //状态 游戏中|匹配中|房间中     在线离线状态不存
    public const DB_MEMBER = "Member";   //会员
    public const DB_FRIEND_REJECT = "FriendReject";   //拒绝别人申请好友开关 1:拒绝 0:同意
    public const DB_LATELY_MATCH_FRIEND = "LatelyMatchFriend";  //最近比赛的好友json列表


    public const DB_KEY_MAP = array(
        self::DB_LOCATION => "Location",
        self::DB_Status => "Status",
        self::DB_MEMBER => "Member",
        self::DB_FRIEND_REJECT => "FriendReject",
        AccountData::DB_LOGOUT_TIME => "OfflineTime",
        self::DB_LATELY_MATCH_FRIEND => "LatelyMatch",
    );

    public int $playerId = 0;
    public string $Location = "";
    public int $Status = GameConstantDefine::PLAYER_STATUS_ONLINE;
    public int $Member = 0;
    public int $FriendReject = 0;
    public int $OfflineTime = 0;
    public string $LatelyMatch = "";

    public function initRoleExtData(array &$data)
    {
        foreach (self::DB_KEY_MAP as $key => $val){
            $data[$key] = $this->$val;
        }
    }

    #更新Role信息
    public function updateRoleExt(array $roleExtData): bool
    {
        $resData = [];
        foreach (self::DB_KEY_MAP as $k => $v) {
            if (array_key_exists($k, $roleExtData)) {
                $resData[$k] = $roleExtData[$k];
            }
        }
        return $this->updateTitle(
            DBTableDefine::TABLE_ACCOUNT,
            $this->playerId,
            0,
            $resData
        );
    }
}