<?php

/**
 * 比赛记录
 */

namespace Game\Data;

use Framework\Lib\Utils;
use Framework\Log\LogMark;
use Framework\DB\Handler\PlayerDBHandler;
use Game\Constant\DBTableDefine;
use Game\Constant\GameErrorCode;

class RecordData
{
    use PlayerDBHandler;

    public const JOIN_ID = "JoinId";
    public const MAP_ID = "MapID";
    public const ROOM_ID = "RoomID";
    public const MATCH_TYPE = "MatchType";  //比赛类型
    public const MATCH_TIME = "MatchTime";  //比赛时间
    public const COST_TIME = "CostTime";    //比赛用时
    public const CAR_INFO = "CarInfo";
    public const RESULT = "Result";                     //胜负 根据比赛类型判断 个人赛为对应名次 团队赛0负1胜
    public const MATCHING_DATA = "MatchingData";        //匹配结果
    public const RACE_RESULT_DATA = "RaceResultData";   //比赛结果
    public const MATCH_UID = "MatchUID";   //比赛结果
    public const CAR_ID = "CarId";          //car Tpl Id
    public const MATCH_RECORD_DETAIL = "MatchRecordDetail";     //比赛显示结果,统计信息比赛详情用
    public const CLIENT_STATISTICS = "ClientStatistics";    //客户端统计信息,只保存转发

    public const DB_KEY_MAP = array(
        self::JOIN_ID => "joinId",
        self::MAP_ID => "mapID",
        self::ROOM_ID => "roomID",
        self::MATCH_TYPE => "matchType",
        self::MATCH_TIME => "matchTime",
        self::COST_TIME => "costTime",
        self::CAR_INFO => "carInfo",
        self::RESULT => "result",
        self::MATCHING_DATA => "matchingData",
        self::RACE_RESULT_DATA => "raceResultData",
        self::MATCH_UID => "matchUID",
        self::CAR_ID => "carId",
        self::MATCH_RECORD_DETAIL => "matchRecordDetail",
        self::CLIENT_STATISTICS => "clientStatistics",
    );

    public int $playerId;
    public int $joinId;
    public int $mapID;
    public int $roomID;
    public int $matchType;
    public int $matchTime;
    public int $costTime;
    public string $carInfo;
    public int $result;
    public string $matchingData;
    public string $raceResultData;
    public int $matchUID;
    public int $carId;
    public string $matchRecordDetail;   //GCMatchRecordDetail->JsonString
    public string $clientStatistics;

    public function __construct(int $playerId, int $joinId)
    {
        $this->playerId = $playerId;
        $this->joinId = $joinId;
    }

    public function initRecord(int $mapID, int $matchType, int $roomID, int $carId): bool
    {
        $this->matchTime = Utils::getServerTimestamp();
        $this->mapID = $mapID;
        $this->roomID = $roomID;
        $this->matchType = $matchType;
        $this->costTime = 0;
        $this->carInfo = 0;
        $this->result = 0;
        $this->matchUID = 0;
        $this->matchingData = "";
        $this->raceResultData = "";
        $this->carId = $carId;
        $this->matchRecordDetail = "";
        $this->clientStatistics = "";
        if(!$this->createRecord()) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_CREATE_ERROR,
                '[recordData] create record error!',
            );
            return false;
        }
        return true;
    }

    private function createRecord(): bool
    {
        $data = array();
        foreach (self::DB_KEY_MAP as $k => $v) {
            $data[$k] = $this->$v;
        }
        if(!$this->createTitle(
            DBTableDefine::TABLE_RECORD,
            $this->playerId,
            $this->joinId,
            $data,
            $this->matchTime
        )) {
            LogMark::getInstance()->markWarn(
                GameErrorCode::DATA_CREATE_ERROR,
              '[RecordData] create record error!',
                        $data
            );
            return false;
        }
        return true;
    }

    public function getRecordData(): bool
    {
        $result = array();
        if(!$this->searchTitle(
            DBTableDefine::TABLE_RECORD,
            $this->playerId,
            $this->joinId,
            $result)
        ) {
            return false;
        }
        $this->formatData($result);
        return true;
    }

    public function saveDB(array $data): bool
    {
        if(!$this->updateTitle(
            DBTableDefine::TABLE_RECORD,
            $this->playerId,
            $this->joinId,
            $data)
        ) {
            LogMark::getInstance()->markWarn(
                GameErrorCode::DATA_UPDATE_ERROR,
                '[RecordData] update record error!',
                $data);
            return false;
        }
        return true;
    }

    public function delRecord(): bool
    {
        if(!$this->deleteTitle(
            DBTableDefine::TABLE_RECORD,
            $this->playerId,
            $this->joinId)
        ) {
            LogMark::getInstance()->markWarn(
                GameErrorCode::DATA_DELETE_ERROR,
                '[RecordData] delete record error!',
                array(
                    "playerId" => $this->playerId,
                    "joinId" => $this->joinId
                )
            );
            return false;
        }
        return true;
    }

    private function formatData($result)
    {
        foreach ($result as $key => $value) {
            $val = self::DB_KEY_MAP[$key] ?? $key;
            if (is_numeric($value)) {
                $this->$val = (int)$value;
            }  else {
                $this->$val = $value;
            }
        }
    }
}
