<?php

/**
 * 比赛记录收藏,zset value为joinId score为添加时间
 */

namespace Game\Data;

use Framework\Lib\Utils;
use Framework\Log\LogMark;
use Framework\DB\Handler\PlayerDBHandler;
use Game\Constant\DBTableDefine;

class RecordCollectionData
{
    use PlayerDBHandler;

    public int $playerId;

    public function __construct(int $playerId)
    {
        $this->playerId = $playerId;
    }

    //获取收藏记录数量
    public function getRecordCollectionNum(): int
    {
        $result = 0;
        if (!$this->searchRankNum(
            DBTableDefine::TABLE_RECORD_COLLECTION,
            $this->playerId ,
            $result))
        {
            LogMark::getInstance()->markDebug(
                "[RecordCollectionData] getRecordCollectionNum fail"
            );
            return 0;
        }
        return (int)$result;
    }

    //增加收藏记录--按收藏时间
    public function addRecordCollection(int $joinId): bool
    {
        if (!$this->addRank(
            DBTableDefine::TABLE_RECORD_COLLECTION,
            $this->playerId,
            $joinId,
            Utils::getServerTimestamp())
        ){
            LogMark::getInstance()->markDebug(
                '[RecordCollectionData] addRecordCollection error!',
                array(
                    "joinId" => $joinId
                )
            );
            return false;
        }
        return true;
    }

    //取消收藏
    public function removeRecordCollection(int $joinId): bool
    {
        if (!$this->delRank(
            DBTableDefine::TABLE_RECORD_COLLECTION,
            $this->playerId,
            $joinId)
        ){
            LogMark::getInstance()->markDebug(
                '[RecordCollectionData] removeRecordCollection error!',
                array(
                    "joinId" => $joinId
                )
            );
            return false;
        }
        return true;
    }

    //检查记录是否已收藏
    public function checkHasCollection(int $joinId): bool
    {
        $res = 0;
        if (!$this->searchRankScoreInDBIndex(
            DBTableDefine::TABLE_RECORD_COLLECTION,
            $this->playerId,
            $joinId,
            $res)
        ){
            LogMark::getInstance()->markInfo(
                '[RecordCollectionData] checkHasCollection error!',
                array(
                    "joinId" => $joinId
                )
            );
            return false;
        }
        if(empty($res)) {
            return false;
        }
        return true;
    }

    //获取收藏id 按时间从大到小排序
    public function getAllCollectionIds(int $start, int $stop): array
    {
        $result = array();
        if(!$this->searchRankByIndex(
            DBTableDefine::TABLE_RECORD_COLLECTION,
            $this->playerId,
            $start,
            $stop,
            $result)
        ) {
            return array();
        }
        return array_keys($result);
    }
}
