<?php
/**
 * 排行榜点赞数据类
 */

namespace Game\Data\Rank;

use Framework\Lib\Utils;
use Framework\Log\LogMark;
use Framework\DB\Handler\CommonDBHandler;
use Game\Constant\DBTableDefine;
use Game\Constant\GameErrorCode;

class RankLikesData {
    use CommonDBHandler;

    public int $rankType;
    public int $seasonID;
    public int $mapID;

    public int $key   =  0;
    public int $score =  1;     // 默认一次 后面统计次数再修改

    public int $playerID = 0;   // 点赞的玩家id   table-playerID: like bePlayerID
    public int $bePlayerID = 0; // 被点赞的玩家ID  table-bePlayerID: like playerID

    public function __construct(int $rankType = 0, int $seasonID = 0, int $mapID = 0)
    {
        $this->rankType = $rankType;
        $this->seasonID = $seasonID;
        $this->mapID = $mapID;
    }

    public function rankLikeData():bool {
        // 判断键是否存在 存在直接存值 不存在需要设置expire
        $likeExists = 0;
        $this->searchRankKeyExists(DBTableDefine::TABLE_RANK_LIKE, $this->rankType, $this->seasonID, $this->mapID,
            $likeExists, $this->playerID);
        if(!$this->addRanking(DBTableDefine::TABLE_RANK_LIKE, $this->rankType, $this->seasonID, $this->mapID,
            $this->bePlayerID, $this->score, $this->playerID)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_UPDATE_ERROR,
                '[rank like data] add rank like error!'
            );
            return false;
        }
        if(!$this->addRanking(DBTableDefine::TABLE_RANK_BE_LIKED, $this->rankType, $this->seasonID, $this->mapID,
            $this->playerID, $this->score, $this->bePlayerID)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_UPDATE_ERROR,
                '[rank like data] add rank be liked error!'
            );
            return false;
        }
        if($likeExists == 0) {
            // 今天结束时间差值（s）
            $time = strtotime('tomorrow') - Utils::getServerTimestamp();
            if(!$this->setRankKeyExpire(DBTableDefine::TABLE_RANK_LIKE, $this->rankType, $this->seasonID,
                $this->mapID, $time, $this->playerID)) {
                LogMark::getInstance()->markError(
                    GameErrorCode::DATA_UPDATE_ERROR,
                    '[rank cache data]  rank set like expire error!'
                );
                return false;
            }
            if(!$this->setRankKeyExpire(DBTableDefine::TABLE_RANK_BE_LIKED, $this->rankType, $this->seasonID,
                $this->mapID, $time, $this->bePlayerID)) {
                LogMark::getInstance()->markError(
                    GameErrorCode::DATA_UPDATE_ERROR,
                    '[rank cache data]  rank set like expire error!'
                );
                return false;
            }
        }

        return true;
    }

    public function getRankBeLikedNumber(&$result): bool {
        if(!$this->getRankNum(DBTableDefine::TABLE_RANK_BE_LIKED, $this->rankType, $this->seasonID, $this->mapID,
            $result, $this->bePlayerID)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_SEARCH_ERROR,
                '[rank like data] get rank like num error!',
                ['rankType' => $this->rankType, 'seasonID' => $this->seasonID, 'mapID' => $this->mapID]
            );
            return false;
        }
        return true;
    }

    // 获取玩家是否点过赞
    public function getLikeKeys(&$result): bool {
        if($this->searchRankData(DBTableDefine::TABLE_RANK_LIKE, $this->rankType, $this->seasonID,
            0, -1, $this->mapID, $res, $this->playerID)) {
            $result = [];
            foreach ($res as $pid => $num) {
                $line = [
                    'playerID' => $pid,
                    'num'      => $num,
                ];
                $result[] = $line;
            }
        } else {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_SEARCH_ERROR,
                '[rank like data] get rank like keys error!',
                ['rankType' => $this->rankType, 'seasonID' => $this->seasonID, 'mapID' => $this->mapID]
            );
            return false;
        }
        return true;
    }

    // 获取玩家是否点过赞
    public function getRankLikeScore(&$result): bool {
        if(!$this->searchRankLikeScoreByKey(DBTableDefine::TABLE_RANK_LIKE, $this->rankType, $this->seasonID,
            $this->mapID, $this->key, $result, $this->playerID)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_SEARCH_ERROR,
                '[rank like data] get rank like score by key error!',
                ['rankType' => $this->rankType, 'seasonID' => $this->seasonID, 'mapID' => $this->mapID]
            );
            return false;
        }
        return true;
    }

    public function delRankLikesCacheData(): bool {
        if(!$this->delRankCacheData(DBTableDefine::TABLE_RANK_BE_LIKED, $this->rankType, $this->seasonID,
            $this->mapID)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_DELETE_ERROR,
                '[rank cache data] del rank like error!',
                ['rankType' => $this->rankType, 'seasonID' => $this->seasonID, 'mapID' => $this->mapID]
            );
            return false;
        }
        return true;
    }

    public function setRankType(int $rankType) {
        $this->rankType = $rankType;
    }

    public function setSeasonID(int $seasonID) {
        $this->seasonID = $seasonID;
    }

    public function setMapID(int $mapID) {
        $this->mapID = $mapID;
    }

    public function setKey(int $key) {
        $this->key = $key;
    }

    public function setScore(int $score) {
        $this->score = $score;
    }
}