<?php
/**
 * 排行榜信息数据类
 */

namespace Game\Data\Rank;

use Framework\Log\LogMark;
use Framework\DB\Handler\CommonDBHandler;
use Game\Constant\DBTableDefine;
use Game\Constant\GameErrorCode;
use Game\Model\Rank\RankModel;

class RankInfoData {
    use CommonDBHandler;

    public int $rankType;
    public int $seasonID;
    public int $mapID;

    public int    $key  = 0;
    public string $data = "";

    public function __construct(int $rankType = 0, int $seasonID = 0, int $mapID = 0)
    {
        if(!empty($rankType)) {
            $this->rankType = RankModel::RANK_INFO_MAP[$rankType];
        }
        $this->seasonID = $seasonID;
        $this->mapID = $mapID;
    }

    public function addRankInfoData():bool {
        if(!$this->addRankingInfo(DBTableDefine::TABLE_RANKING_INFO, $this->rankType, $this->seasonID,
            $this->mapID, [$this->key => $this->data])) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_UPDATE_ERROR,
                '[rank info data] change ranking info error!'
            );
            return false;
        }
        return true;
    }

    public function getRankInfoData(array $keys, array &$result): bool {
        if(!$this->getRankingInfo($result,DBTableDefine::TABLE_RANKING_INFO, $this->rankType,
            $this->seasonID, $this->mapID, $keys)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_DELETE_ERROR,
                '[rank info data] find ranking info error!',
                ['rankType' => $this->rankType, 'seasonID' => $this->seasonID, 'mapID' => $this->mapID]
            );
            return false;
        }
        return true;
    }

    public function addRankSyncTimeData():bool {
        if(!$this->addRankingInfo(DBTableDefine::TABLE_RANK_SYNC_TIME, 0, 0, 0,
            [$this->key => $this->data])) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_UPDATE_ERROR,
                '[rank time data] change ranking sync time error!'
            );
            return false;
        }
        return true;
    }

    public function getRankSyncTimeData(array $keys, array &$result): bool {
        if(!$this->getRankingInfo($result,DBTableDefine::TABLE_RANK_SYNC_TIME, 0, 0,
            0, $keys)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_DELETE_ERROR,
                '[rank info data] find ranking sync time error!',
            );
            return false;
        }
        return true;
    }

    public function setRankType(int $rankType) {
        if(!empty($rankType) && isset(RankModel::RANK_INFO_MAP[$rankType])) {
            $this->rankType = RankModel::RANK_INFO_MAP[$rankType];
        } else {
            $this->rankType = $rankType;
        }
    }

    public function setSeasonID(int $seasonID) {
        $this->seasonID = $seasonID;
    }

    public function setMapID(int $mapID) {
        $this->mapID = $mapID;
    }

    public function setKey(string $key) {
        $this->key = $key;
    }

    public function setData(string $data) {
        $this->data = $data;
    }
}