<?php
/**
 * 排行榜数据类
 */

namespace Game\Data\Rank;

use Framework\Log\LogMark;
use Framework\DB\Handler\CommonDBHandler;
use Game\Constant\DBTableDefine;
use Game\Constant\GameErrorCode;

class RankData {
    use CommonDBHandler;

    const CLOTHING            = 'Cloth';
    const CAR_EXTERIOR_REFITS = 'CarExteriorRefits';
    const PLAYER_ID           = 'PlayerID';
    const SCORE               = 'Score';
    const BE_LIKED            = 'BeLiked';

    public int $rankType;
    public int $seasonID;
    public int $mapID;

    public int $key   =  0;
    public float $score =  0;
    public int $start =  0;
    public int $end   = -1;

    public function __construct(int $rankType = 0, int $seasonID = 0, int $mapID = 0)
    {
        $this->rankType = $rankType;
        $this->seasonID = $seasonID;
        $this->mapID = $mapID;
    }

    public function addRankData():bool {
        if(!$this->addRanking(DBTableDefine::TABLE_RANKING, $this->rankType, $this->seasonID, $this->mapID,
            $this->key, $this->score)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_UPDATE_ERROR,
                '[rank data] change ranking error!'
            );
            return false;
        }
        return true;
    }

    public function searchRankDataByScore(&$result): bool {
        // searchScore >= score && searchScore < score + 1
        if(!$this->searchRankDataByScoreWithScores(DBTableDefine::TABLE_RANKING, $this->rankType, $this->seasonID,
            $this->mapID, '(' . (int)$this->score, '(' . ((int)$this->score +1), $result)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_SEARCH_ERROR,
                '[rank data] get rank by score with scores error!',
                ['rankType' => $this->rankType, 'seasonID' => $this->seasonID, 'mapID' => $this->mapID]
            );
            return false;
        }
        return true;
    }

    public function deleteRankData(): bool {
        if(!$this->remRanking(DBTableDefine::TABLE_RANKING, $this->rankType, $this->seasonID, $this->mapID,
                    $this->key)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_DELETE_ERROR,
                '[rank data] del ranking error!',
                ['rankType' => $this->rankType, 'seasonID' => $this->seasonID, 'mapID' => $this->mapID, 'key' =>
                    $this->key]
            );
            return false;
        }
        return true;
    }

    // 删除排行榜个人数据
    public function deleteRankPlayer(): bool {
        if(!$this->remRanking(DBTableDefine::TABLE_RANKING, $this->rankType, $this->seasonID, $this->mapID,
            $this->key)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_DELETE_ERROR,
                '[rank data] gm del ranking error!',
                ['rankType' => $this->rankType, 'seasonID' => $this->seasonID, 'mapID' => $this->mapID, 'key' =>
                    $this->key]
            );
            return false;
        }
        return true;
    }

    public function getRankNumber(&$result): bool {
        if(!$this->getRankNum(DBTableDefine::TABLE_RANKING, $this->rankType, $this->seasonID, $this->mapID,
            $result)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_SEARCH_ERROR,
                '[rank data] get rank num error!',
                ['rankType' => $this->rankType, 'seasonID' => $this->seasonID, 'mapID' => $this->mapID]
            );
            return false;
        }
        return true;
    }

    public function findRankData(&$result): bool {
        if(!$this->searchRankData(DBTableDefine::TABLE_RANKING, $this->rankType, $this->seasonID, $this->start,
            $this->end, $this->mapID, $result)) {
            logMark::getInstance()->markError(
                GameErrorCode::DATA_SEARCH_ERROR,
                '[rank data] find rank key error!',
                ['rankType' => $this->rankType, 'seasonID' => $this->seasonID, 'mapID' => $this->mapID]
            );
            return false;
        }
        return true;
    }

    public function findRevRankData(&$result): bool {
        if(!$this->searchRevRankData(DBTableDefine::TABLE_RANKING, $this->rankType, $this->seasonID, $this->start,
            $this->end, $this->mapID, $result)) {
            logMark::getInstance()->markError(
                GameErrorCode::DATA_SEARCH_ERROR,
                '[rank data] find rank key error!',
                ['rankType' => $this->rankType, 'seasonID' => $this->seasonID, 'mapID' => $this->mapID]
            );
            return false;
        }
        return true;
    }

    public function setRankType(int $rankType) {
        $this->rankType = $rankType;
    }

    public function setSeasonID(int $seasonID) {
        $this->seasonID= $seasonID;
    }

    public function setMapID(int $mapID) {
        $this->mapID = $mapID;
    }

    public function setKey(int $key) {
        $this->key = $key;
    }

    public function setScore(float $score) {
        $this->score = $score;
    }
}