<?php
/**
 * 排行榜缓存数据类
 */

namespace Game\Data\Rank;

use Framework\Log\LogMark;
use Framework\DB\Handler\CommonDBHandler;
use Framework\Logic\TemplateHelp;
use Game\Constant\ConstTemplate\TemplateConst;
use Game\Constant\DBTableDefine;
use Game\Constant\GameErrorCode;
use Game\Constant\TemplateDefine;

class RankCacheData {
    use CommonDBHandler;
    use TemplateHelp;

    public int $rankType;
    public int $seasonID;
    public int $mapID;

    public string $data = "";

    public function __construct(int $rankType = 0, int $seasonID = 0, int $mapID = 0)
    {
        $this->rankType = $rankType;
        $this->seasonID = $seasonID;
        $this->mapID = $mapID;
    }

    public function addRankingCacheData():bool {
        if(!$this->setRankCacheData(DBTableDefine::TABLE_RANK_CACHE, $this->rankType, $this->seasonID,
            $this->mapID, $this->data)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_UPDATE_ERROR,
                '[rank cache data]  rank set cache error!'
            );
            return false;
        }
        $cacheExpire = $this->getTerm(TemplateDefine::TYPE_CONST,
            TemplateConst::Const_Rank_Data_Cache_Time_Out, "Const_num");
        if(!$this->setRankKeyExpire(DBTableDefine::TABLE_RANK_CACHE, $this->rankType, $this->seasonID,
            $this->mapID, $cacheExpire)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_UPDATE_ERROR,
                '[rank cache data]  rank set cache expire error!'
            );
            return false;
        }
        return true;
    }

    public function getRankingCacheData(string &$result): bool {
        if(!$this->getRankCacheData(DBTableDefine::TABLE_RANK_CACHE, $this->rankType, $this->seasonID,
            $this->mapID, $result)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_SEARCH_ERROR,
                '[rank cache data] find ranking cache error!',
                ['rankType' => $this->rankType, 'seasonID' => $this->seasonID, 'mapID' => $this->mapID]
            );
            return false;
        }
        return true;
    }

    public function delRankingCacheData(): bool {
        if(!$this->delRankCacheData(DBTableDefine::TABLE_RANK_CACHE, $this->rankType, $this->seasonID,
            $this->mapID)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_DELETE_ERROR,
                '[rank cache data] del ranking cache error!',
                ['rankType' => $this->rankType, 'seasonID' => $this->seasonID, 'mapID' => $this->mapID]
            );
            return false;
        }
        return true;
    }

    public function setRankType(int $rankType) {
        $this->rankType = $rankType;
    }

    public function setSeasonID(int $seasonID) {
        $this->seasonID = $seasonID;
    }

    public function setMapID(int $mapID) {
        $this->mapID = $mapID;
    }

    public function setData(string $data) {
        $this->data = $data;
    }
}