<?php

/***
 * 取消匹配
 */

namespace Game\Data\PvpPacket;

use Framework\Log\LogMark;
use Framework\DB\Handler\MatchingDBHandler;
use Framework\DB\Handler\PlayerDBHandler;
use Game\Constant\DBTableDefine;
use Game\Constant\GameConstantDefine;
use Game\Protobuf\GMCancelMatch;


class CancelMatchData
{
    use MatchingDBHandler;

    public int    $playerId;
    public int    $joinID;     // 取消玩家ID
    public int    $serverID;     // 取消玩家ID
    
    public function writePacket(): string {
        $match = new GMCancelMatch();
        $match->setJoinID($this->joinID);
        $match->setServerID($this->serverID);
        return base64_encode($match->serializeToString());
    }

    public function sendPacket(int $msgID): bool {
        $sendStr = $msgID. '@' .$this->writePacket();
        LogMark::getInstance()->markDebug(
            "[PVPFlowLog][data] cancel match", ['cancel join id' => $this->joinID]
        );
        return $this->addQueueByDBKey(
            DBTableDefine::TABLE_CANCEL_MATCH,
            GameConstantDefine::DBKEY_COMPETE_SERVER_MATCH,
            $sendStr);
    }
}
