<?php

/**
 * 排位赛数据
 */

namespace Game\Data\PaiWei;

use Framework\DB\Handler\PlayerDBHandler;
use Framework\Logic\TemplateHelp;
use Game\Constant\ConstTemplate\TemplateConst;
use Game\Constant\DBTableDefine;
use Game\Constant\TemplateDefine;

class PaiweiLevelData
{
    use PlayerDBHandler;
    use TemplateHelp;

    public int $playerId;

    public const LEVEL_ID = "levelId";
    public const SCORE = "score";
    public const MAX_LEVEL_ID = "maxLevelId";
    public const GUARD_SCORE = "guardScore";
    public const RECORD = "record";
    public const SEASON_ID = "seasonId";
    public const POSITION_ORDER = "positionOrder";
    public const DAILY_WIN_NUM = "dailyWinNum";
    public const DAILY_MATCH_NUM = "dailyMatchNum";
    public const SEASON_MATCH_RECORD = "seasonMatchRecord";
    public const GAP_DAY = "gapDay";
    public const FIRST_CHOICE_NUM = "firstChoiceNum";
    public const SEASON_SCORE = "seasonScore";
    public const SEASON_REWARD = "seasonReward";
    public const OVER_FLOW_EXP = "overFlowExp";
    public const HAVE_REWARD_NUM = "haveRewardNum";
    public const REWARD_NUM = "rewardNum";

    public int $levelId;        //段位Id
    public int $score;          //积分
    public int $maxLevelId;     //历史最高段位Id
    public int $guardScore;     //保护分
    public int $record;         //连胜或连败记录 >0为连胜 <0为连败 每日重置
    public int $seasonId;       //当前所处赛季Id
    public string $positionOrder;    //定位排序 [位置id,..]
    public int $dailyWinNum = 0;    //每日胜利次数(每日首胜)  每日重置
    public int $dailyMatchNum = 0;  //每日比赛次数,活跃分生效场次用 每日重置
    public string $seasonMatchRecord = "[]";   //赛季比赛胜负记录[胜1,负0] 30场 赛季重置
    public int $gapDay = 0;         //上次登录间隔天数
    public int $firstChoiceNum = 1; //团队赛,首选命中场次    每日重置
    public int $seasonScore = 0;     // 赛季分
    public array $seasonReward = []; // 赛季奖励领取记录
    public int $overFlowExp = 0;     // 赛季等级max 冗余分
    public int $haveRewardNum = 0;   // 可领取循环奖励次数
    public int $rewardNum = 0;       // 总领取循环奖励次数


    public const POSITION_RACE = 1;     //位置-竞速
    public const POSITION_JAM = 2;      //位置-干扰
    public const POSITION_HELP = 3;     //位置-辅助

    public const POSITION_RANDOM_CLOSE = 0;
    public const POSITION_RANDOM_OPEN = 1;

    public const DB_KEY_MAP = array(
        self::LEVEL_ID => self::LEVEL_ID ,
        self::SCORE => self::SCORE,
        self::MAX_LEVEL_ID => self::MAX_LEVEL_ID,
        self::GUARD_SCORE => self::GUARD_SCORE,
        self::RECORD => self::RECORD,
        self::SEASON_ID => self::SEASON_ID,
        self::POSITION_ORDER => self::POSITION_ORDER,
        self::DAILY_WIN_NUM => self::DAILY_WIN_NUM,
        self::DAILY_MATCH_NUM => self::DAILY_MATCH_NUM,
        self::SEASON_MATCH_RECORD => self::SEASON_MATCH_RECORD,
        self::GAP_DAY => self::GAP_DAY,
        self::FIRST_CHOICE_NUM => self::FIRST_CHOICE_NUM,
        self::SEASON_SCORE => self::SEASON_SCORE,
        self::SEASON_REWARD => self::SEASON_REWARD,
        self::OVER_FLOW_EXP => self::OVER_FLOW_EXP,
        self::HAVE_REWARD_NUM => self::HAVE_REWARD_NUM,
        self::REWARD_NUM => self::REWARD_NUM,
    );

    public function createDB(): bool
    {
        $data = $this->getData();
        return $this->createTitle(
            DBTableDefine::TABLE_PAIWEI_LEVEL,
            $this->playerId,
            0,
            $data
        );
    }

    public function saveLevel(): bool
    {
        //检查金牌车手
        $goldId = (int)$this->getTerm(
            TemplateDefine::TYPE_CONST,
            TemplateConst::Const_Ranking_Gold_Player_Level,
            TemplateConst::ConstNum
        );
        if ($this->levelId >= $goldId) {
            $this->levelId = $goldId -1;
        }
        $data = $this->getData();
        return $this->updateTitle(
            DBTableDefine::TABLE_PAIWEI_LEVEL,
            $this->playerId,
            0,
            $data
        );
    }

    //修改他人数据
    public function saveTargetLevel(int $targetPlayerId, array $data): bool
    {
        return $this->updateTitle(
            DBTableDefine::TABLE_PAIWEI_LEVEL,
            $targetPlayerId,
            0,
            $data
        );
    }

    public function getLevelFromDB(): bool
    {
        $result = array();
        if (!$this->searchTitle(
            DBTableDefine::TABLE_PAIWEI_LEVEL,
            $this->playerId,
            0,
            $result
        )) {
            return false;
        }
        if (empty($result)) {
            return false;
        }
        foreach ($result as $key => $value) {
            $this->formatData($key, $value);
        }
        //检查是否是金牌车手
        if ($this->checkIsGoldPlayer()) {
            $goldId = (int)$this->getTerm(
                TemplateDefine::TYPE_CONST,
                TemplateConst::Const_Ranking_Gold_Player_Level,
                TemplateConst::ConstNum
            );
            $this->levelId = $goldId;
        }
        return true;
    }

    private function getData(): array
    {
        $data = array();
        foreach (self::DB_KEY_MAP as $k => $v) {
            if($k == self::SEASON_REWARD) {
                $data[$k] = json_encode($this->$k);
            } else {
                $data[$k] = $this->$k;
            }
        }
        return $data;
    }

    public function formatData($key, $value)
    {
        $val = self::DB_KEY_MAP[$key] ?? null;
        if (is_null($val)) {
            return;
        }
        switch ($key)
        {
            case self::POSITION_ORDER:
            case self::SEASON_MATCH_RECORD:
                $this->$val = $value;
                break;
            case self::SEASON_REWARD:
                $this->$val = json_decode($value, true);
                break;
            default:
                $this->$val = (int)$value;
        }
    }

    //检查玩家是否是金牌车手
    private function checkIsGoldPlayer(): bool
    {
        $this->searchTerm(
            $ret,
            DBTableDefine::TABLE_PAI_WEI_GOLD,
            0,
            0,
            $this->playerId
        );
        //没有 ret="" 为0
        return (int)$ret > 0;
    }
}
