<?php

/**
 * 排位赛金牌信息
 */

namespace Game\Data\PaiWei;

use Framework\DB\Handler\PlayerDBHandler;
use Game\Constant\DBTableDefine;

class PaiWeiGoldData
{
    use PlayerDBHandler;

    public int $playerId;

    public function setPlayerId(int $playerId)
    {
        $this->playerId = $playerId;
    }

    //删除金牌选手id
    public function delGoldPlayer(): bool
    {
        return $this->deleteTable(
            DBTableDefine::TABLE_PAI_WEI_GOLD,
            0,
            0
        );
    }

    //更新金牌选手Id
    public function updateGoldPlayer(array $data): bool
    {
        return $this->updateTitle(
            DBTableDefine::TABLE_PAI_WEI_GOLD,
            0,
            0,
            $data
        );
    }

    //金牌排行

    //更新金牌选手排行数据
    public function updateGoldPlayerRankScore(int $score): bool
    {
        return $this->addPlayerRank(
            DBTableDefine::TABLE_PAI_WEI_GOLD_RANK,
            0,
            0,
            $this->playerId,
            $score
        );
    }

    //获取前100名数据--根据索引
    //$result=>array(playerId=>score)
    public function getTop100GoldPlayer(): array
    {
        $result = array();
        $this->searchRankByIndex(
            DBTableDefine::TABLE_PAI_WEI_GOLD_RANK,
            0,
            0,
            99,
            $result
        );
        return $result;
    }

    //获取超过分数的玩家
    //$result=>array(playerId=>score)
    public function getTopGoldPlayer(int $startScore): array
    {
        $result = array();
        $this->searchRevRankByIndex(
            DBTableDefine::TABLE_PAI_WEI_GOLD_RANK,
            0,
            $startScore,
            99999999,
            $result
        );
        return $result;
    }
}
