<?php

/**
 * 行驶证车辆完成关卡数
 */

namespace Game\Data\PVE;

use Framework\Log\LogMark;
use Framework\DB\Handler\PlayerDBHandler;
use Game\Constant\DBTableDefine;

class DrivingPermitData
{
    use PlayerDBHandler;

    public int $playerId;

    public function __construct(int $playerId)
    {
        $this->playerId = $playerId;
    }

    /**
     * 查询车辆完成关卡数
     * @return array carId=>num
     */
    public function searchDB(): array
    {
        $result = array();
        if (!$this->searchTitle(
            DBTableDefine::TABLE_DRIVING_PERMIT,
            $this->playerId,
            0,
            $result
            )
        ) {
            LogMark::getInstance()->markDebug(
                "[DrivingPermitData] searchDB error",
                array(
                    "PlayerId" => $this->playerId
                )
            );
            return array();
        }
        $arr = array();
        foreach ($result as $key => $value) {
            $arr[(int)$key] = $value;
        }
        return $arr;
    }

    //增加车辆完成关卡数
    public function increaseCompleteLevelNum(string $key, int $value = 1): bool
    {
        return $this->autoAddTerm(
            DBTableDefine::TABLE_DRIVING_PERMIT,
            $this->playerId,
            0,
            $key,
            $value,
            $ret
        );
    }

}